import 'package:flutter/cupertino.dart';
import 'package:flutter_livepush_plugin/pusher/live_push_config.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/1/23 10:33
 * @brief
 */

enum CameraPushPagePreviewState {
  startPreview,
  stopPreview,
}

enum CameraPushPagePushState {
  startPush,
  stopPush,
  pausePush,
}

enum CameraPushPageBottomSheetState {
  showMusic,
  showMoreSetting,
  nothing,
}

///bgm
class BGMState {
  bool isOpenBGMEarsBack = false;
  bool isOpenAudioDenoise = false;
  bool isBGMMute = false;
  bool isBGMLoop = false;
  bool isBGMPlaying = false;
  int bgmVolume = 50;
  int bgmCaptureVolume = 50;
  int bgmSelectedIndex = 0;
  int bgmProgress = 0;
  int bgmDuration = 0;

  @override
  BGMState clone() => BGMState()
    ..bgmVolume = bgmVolume
    ..bgmCaptureVolume = bgmCaptureVolume
    ..isOpenBGMEarsBack = isOpenBGMEarsBack
    ..isOpenAudioDenoise = isOpenAudioDenoise
    ..isBGMMute = isBGMMute
    ..isBGMLoop = isBGMLoop
    ..isBGMPlaying = isBGMPlaying
    ..bgmSelectedIndex = bgmSelectedIndex
    ..bgmProgress = bgmProgress
    ..bgmDuration = bgmDuration;
}

///more setting
class PushSettingState {
  bool isOpenPushMirror = false;
  bool isOpenPreviewMirror = false;
  int videoTargetBitrate = 1400;
  int videoMinBitrate = 600;
  int previewModelIndex = 1;

  @override
  PushSettingState clone() => PushSettingState()
    ..isOpenPushMirror = isOpenPushMirror
    ..isOpenPreviewMirror = isOpenPreviewMirror
    ..videoTargetBitrate = videoTargetBitrate
    ..videoMinBitrate = videoMinBitrate
    ..previewModelIndex = previewModelIndex;
}

class CameraPushState {
  late BuildContext mContext;
  String pushURL = "";
  bool isOpenFlashLamp = false;
  AlivcLivePushConfig pusherConfig = AlivcLivePushConfig.init();
  bool beautyOn = false;
  int livePushMode = 0;
  bool showBeautyMenu = false;
  String pushStatusTip = "";

  BGMState bgmState = BGMState();
  PushSettingState pushSettingState = PushSettingState();

  CameraPushPageBottomSheetState bottomSheetState =
      CameraPushPageBottomSheetState.nothing;

  CameraPushPagePreviewState previewState =
      CameraPushPagePreviewState.startPreview;
  CameraPushPagePushState pushState = CameraPushPagePushState.stopPush;

  @override
  CameraPushState clone() => CameraPushState()
    ..pushURL = pushURL
    ..beautyOn = beautyOn
    ..livePushMode = livePushMode
    ..showBeautyMenu = showBeautyMenu
    ..bgmState = bgmState
    ..pushSettingState = pushSettingState
    ..bottomSheetState = bottomSheetState
    ..previewState = previewState
    ..pushState = pushState
    ..pushStatusTip = pushStatusTip;
}

// CameraPushState initState(Map<String, dynamic> args) {
//   return CameraPushState()
//     ..pushURL = args[pushURLKey]
//     ..pusherConfig = args[pushConfigKey]
//     ..beautyOn = args[pushBeautyOnKey]
//     ..livePushMode = args[pushMode];
// }
