// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/15
// Brief:

import 'dart:async';
import 'dart:io';
import 'actions.dart';
import 'state.dart';
import 'package:redux/redux.dart';
import 'package:flutter_livepush_plugin/base/live_base.dart';
import 'package:flutter_livepush_demo/common/common_util.dart';

// middleware.dart
List<Middleware<HomeState>> createHomeMiddlewares() {
  return [
    TypedMiddleware<HomeState, HomeAction>(_receiveActions),
  ];
}

void _receiveActions(Store<HomeState> store,
    HomeAction action,
    NextDispatcher next,) {
  if (action.type == HomeActionType.initState) {
    store.state.mContext = action.payload;
    _initState(store);
  }
  next(action);
}

Future<void> _initState(Store<HomeState> store,) async {
  CommonUtil.init();
  _getSDKVersion(store);

  DirType dirType;
  if (Platform.isAndroid) {
    dirType = DirType.externalFile;
  } else {
    dirType = DirType.document;
  }

  // 假设这些数据已经在某个地方定义了
  for (var element in musicList) {
    String path = element.path;
    if (path.isNotEmpty && !path.contains("http://")) {
      var split = path.split("/");
      CommonUtil.saveSystemDirWithAssetsResource(path, dirType, split[2]);
    }
  }
  for (var element in imgList) {
    if (element.isNotEmpty) {
      var split = element.split("/");
      CommonUtil.saveSystemDirWithAssetsResource(element, dirType, split[2]);
    }
  }
}

void _getSDKVersion(Store<HomeState> store,) async {
  String sdkVersion = await AlivcLiveBase.getSdkVersion();
  store.dispatch(HomeAction(
    HomeActionType.getSDKVersion,
    payload: sdkVersion,
  ));
}
