// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/15
// Brief:

import 'package:flutter/material.dart';
import 'package:redux/redux.dart';
import 'state.dart';
import 'actions.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';

class HomePage extends StatefulWidget {
  final Store<HomeState> store;

  HomePage({required this.store});

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  @override
  void initState() {
    super.initState();
    widget.store
        .dispatch(HomeAction(HomeActionType.initState, payload: context));
  }

  @override
  void didUpdateWidget(covariant HomePage oldWidget) {
    // TODO: implement didUpdateWidget
    super.didUpdateWidget(oldWidget);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        children: [
          Stack(
            alignment: Alignment.bottomLeft,
            children: [
              Image.asset("assets/images/homepage_bg.jpg"),
              Container(
                padding: const EdgeInsets.all(22.0),
                child: Text(
                  AppLocalizations.of(context)!.home_theme,
                  style: const TextStyle(fontSize: 42.0),
                ),
              )
            ],
          ),
          Expanded(
            child: GridView.count(
              crossAxisCount: 2,
              mainAxisSpacing: 0,
              crossAxisSpacing: 0,
              childAspectRatio: 1 / 1,
              children:
                  widget.store.state.tabs.map((e) => _buildItem(e)).toList(),
            ),
          ),
          GestureDetector(
            onTap: () {
              widget.store
                  .dispatch(HomeAction(HomeActionType.clickPrivacyPolicy));
            },
            child: Text(
              AppLocalizations.of(context)!.home_privacy_policy,
              style: const TextStyle(color: Color(0xff888888), fontSize: 12),
            ),
          ),
          const SizedBox(height: 5),
          Text(
            AppLocalizations.of(context)!.home_bottom_tip,
            style: const TextStyle(color: Color(0xff888888), fontSize: 11),
          ),
          const SizedBox(height: 5),
          StreamBuilder<HomeState>(
            stream: widget.store.onChange,
            initialData: widget.store.state,
            builder: (context, snapshot) {
              return Text(
                AppLocalizations.of(context)!.home_version +
                    widget.store.state.sdkVersion,
                style: const TextStyle(
                  color: Color(0xff888888),
                  fontSize: 11,
                ),
              );
            },
          ),
        ],
      ),
    );
  }

  Widget _buildItem(HomeTab e) => GestureDetector(
        onTap: () async {
          switch (e.modelType) {
            case ModelType.cameraPush:
              widget.store.dispatch(
                  HomeAction(HomeActionType.clickCameraPush, payload: context));
              break;
            case ModelType.interactiveLive:
              widget.store.dispatch(HomeAction(
                  HomeActionType.clickInteractiveLive,
                  payload: context));
              break;
            case ModelType.interactivePK:
              widget.store.dispatch(HomeAction(
                  HomeActionType.clickInteractivePK,
                  payload: context));
              break;
          }
        },
        child: Container(
          margin: const EdgeInsets.all(15.0),
          padding: const EdgeInsets.only(left: 10.0),
          alignment: Alignment.centerLeft,
          decoration: BoxDecoration(
            //边框
            border: Border.all(color: const Color(0xFFEDEDED), width: 2.0),
            //圆角
            borderRadius: BorderRadius.circular(8.0),
          ),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceAround,
            children: [
              Image.asset(e.iconPath, width: 48.0, height: 48.0),
              Text(
                AppLocalizations.of(context)!.home_page_name(e.title),
                style: const TextStyle(fontSize: 17.0),
              )
            ],
          ),
        ),
      );
}
