// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/15
// Brief:

// state.dart
import 'package:flutter/cupertino.dart';

class HomeState {
  String sdkVersion = '';
  late BuildContext mContext;

  HomeState({this.sdkVersion = ""});

  final List<HomeTab> tabs = [
    HomeTab(
      ModelType.cameraPush,
      "assets/images/ic_camera_push.png",
      "camera_push",
    ),
    HomeTab(
      ModelType.interactiveLive,
      "assets/images/ic_interactive.png",
      "interactive_live",
    ),
    HomeTab(
      ModelType.interactivePK,
      "assets/images/ic_pk.png",
      "interactive_pk",
    ),
  ];
}

class HomeTab {
  ModelType modelType = ModelType.cameraPush;
  String iconPath = '';
  String title = '';

  HomeTab(
    this.modelType,
    this.iconPath,
    this.title,
  );
}

enum ModelType {
  cameraPush,
  interactiveLive,
  interactivePK,
}
