// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/15
// Brief:

enum InteractiveEnrollmentActionType {
  init,
  clickNext,
  clickGoBack,
  settingParameters,
  changeIdentity,
  changeAppInfoState,
  editAppInfo,
  onEditAppInfo,
  changeUserId,
  changeRoomId,
}

class InteractiveEnrollmentAction {
  final InteractiveEnrollmentActionType type;
  final dynamic payload;

  InteractiveEnrollmentAction(this.type, {this.payload});
}

class InteractiveEnrollmentActionCreator {
  static InteractiveEnrollmentAction init() =>
      InteractiveEnrollmentAction(InteractiveEnrollmentActionType.init);

  static InteractiveEnrollmentAction clickNext() =>
      InteractiveEnrollmentAction(InteractiveEnrollmentActionType.clickNext);

  static InteractiveEnrollmentAction clickGoBack() =>
      InteractiveEnrollmentAction(InteractiveEnrollmentActionType.clickGoBack);

  static InteractiveEnrollmentAction settingParameters() =>
      InteractiveEnrollmentAction(
          InteractiveEnrollmentActionType.settingParameters);

  static InteractiveEnrollmentAction editAppInfo() =>
      InteractiveEnrollmentAction(InteractiveEnrollmentActionType.editAppInfo);

  static InteractiveEnrollmentAction onEditAppInfo(newValue) =>
      InteractiveEnrollmentAction(InteractiveEnrollmentActionType.onEditAppInfo,
          payload: newValue);

  static InteractiveEnrollmentAction changeIdentity(dynamic newValue) =>
      InteractiveEnrollmentAction(
        InteractiveEnrollmentActionType.changeIdentity,
        payload: newValue,
      );

  static InteractiveEnrollmentAction changeAppInfoState(bool newValue) =>
      InteractiveEnrollmentAction(
        InteractiveEnrollmentActionType.changeAppInfoState,
        payload: newValue,
      );

  static InteractiveEnrollmentAction changeUserId(String newValue) =>
      InteractiveEnrollmentAction(
        InteractiveEnrollmentActionType.changeUserId,
        payload: newValue,
      );

  static InteractiveEnrollmentAction changeRoomId(String newValue) =>
      InteractiveEnrollmentAction(
        InteractiveEnrollmentActionType.changeRoomId,
        payload: newValue,
      );
}
