// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/15
// Brief:

import 'actions.dart';
import 'state.dart';

InteractiveEnrollmentState interactiveEnrollmentReducer(
  InteractiveEnrollmentState state,
  action,
) {
  if (action is InteractiveEnrollmentAction) {
    switch (action.type) {
      case InteractiveEnrollmentActionType.changeIdentity:
        state.interactiveIdentityTypeEnum = action.payload;
        break;
      case InteractiveEnrollmentActionType.changeAppInfoState:
        state.showAppInfo = action.payload;
        break;
      case InteractiveEnrollmentActionType.changeUserId:
        state.userId = action.payload;
        break;
      case InteractiveEnrollmentActionType.changeRoomId:
        state.roomId = action.payload;
        break;
      default:
        break;
    }
  }
  return state;
}
