// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/16
// Brief:

// actions.dart
enum InteractiveInfoActionType {
  clickNext,
  clickGoBack,
  changeAppId,
  changeAppKey,
  changePlayDomain,
}

class InteractiveInfoAction {
  final InteractiveInfoActionType type;
  final dynamic payload;

  InteractiveInfoAction(this.type, {this.payload});
}

class InteractiveInfoActionCreator {
  static InteractiveInfoAction clickNext() => InteractiveInfoAction(
        InteractiveInfoActionType.clickNext,
      );

  static InteractiveInfoAction clickGoBack() => InteractiveInfoAction(
        InteractiveInfoActionType.clickGoBack,
      );

  static InteractiveInfoAction changeAppId(String newValue) =>
      InteractiveInfoAction(
        InteractiveInfoActionType.changeAppId,
        payload: newValue,
      );

  static InteractiveInfoAction changeAppKey(String newValue) =>
      InteractiveInfoAction(
        InteractiveInfoActionType.changeAppKey,
        payload: newValue,
      );

  static InteractiveInfoAction changePlayDomain(String newValue) =>
      InteractiveInfoAction(
        InteractiveInfoActionType.changePlayDomain,
        payload: newValue,
      );
}
