// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/16
// Brief:

import 'package:flutter/cupertino.dart';
import 'package:flutter_livepush_demo/page/interactive_enrollment/middleware.dart';
import 'package:flutter_livepush_demo/page/interactive_enrollment/page.dart';
import 'package:flutter_livepush_demo/page/interactive_enrollment/reducer.dart';
import 'package:flutter_livepush_demo/page/interactive_enrollment/state.dart';
import 'package:redux/redux.dart';
import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/common/common_util.dart';

import 'actions.dart';
import 'state.dart';

List<Middleware<InteractiveInfoState>> createInteractiveInfoMiddleware() {
  return [
    TypedMiddleware<InteractiveInfoState, InteractiveInfoAction>(
      _handleActions,
    ),
  ];
}

void _handleActions(
  Store<InteractiveInfoState> store,
  InteractiveInfoAction action,
  NextDispatcher next,
) async {
  if (action.type == InteractiveInfoActionType.clickNext) {
    await _clickNext(store);
  } else if (action.type == InteractiveInfoActionType.clickGoBack) {
    _clickGoBack(store);
  }
  next(action);
}

Future<void> _clickNext(Store<InteractiveInfoState> store) async {
  var state = store.state;

  print("appId: ${state.appId}");
  print("appKey: ${state.appKey}");
  print("playDomain: ${state.playDomain}");

  CommonUtil.saveLocal(interactiveAppIdKey, state.appId);
  CommonUtil.saveLocal(interactiveAppKeyKey, state.appKey);
  CommonUtil.saveLocal(interactivePlayDomainKey, state.playDomain);

  var map = {
    interactiveTypeKey: state.interactiveTypeEnum.name,
    interactiveAppIdKey: state.appId,
    interactiveAppKeyKey: state.appKey,
    interactivePlayDomainKey: state.playDomain,
  };

  if (state.fromHomePage) {
    Navigator.of(store.state.context).push(
      CupertinoPageRoute(
          builder: (_) => InteractiveEnrollmentPage(
                store: Store<InteractiveEnrollmentState>(
                  interactiveEnrollmentReducer,
                  initialState: InteractiveEnrollmentState(),
                  middleware: createInteractiveEnrollmentMiddleware(),
                ),
                interactiveAppMap: map,
              )),
    );
  } else {
    Navigator.of(store.state.context).pop(map);
  }
}

void _clickGoBack(Store<InteractiveInfoState> store) {
  FocusScope.of(store.state.context).unfocus();
  Navigator.of(store.state.context).pop();
}
