// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/16
// Brief:

import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/common/common_util.dart';
import 'package:flutter_livepush_demo/widget/interactive_input_view.dart';
import 'package:flutter_livepush_demo/widget/push_button.dart';
import 'package:flutter_livepush_demo/widget/interactive_input_appbar.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';
import 'package:redux/redux.dart';
import 'actions.dart';
import 'state.dart';

class InteractiveInfoPage extends StatefulWidget {
  final Store<InteractiveInfoState> store;
  final Map<String, dynamic>? interactiveInfoMap;

  InteractiveInfoPage({Key? key, required this.store, this.interactiveInfoMap})
      : super(key: key);

  @override
  _InteractiveInfoPageState createState() => _InteractiveInfoPageState();
}

class _InteractiveInfoPageState extends State<InteractiveInfoPage> {
  @override
  void initState() {
    if (widget.interactiveInfoMap?.keys == null) {
      return;
    }
    InteractiveTypeEnum typeEnum;
    widget.interactiveInfoMap![interactiveIdentityKey] ==
            InteractiveTypeEnum.interactiveLive.name
        ? typeEnum = InteractiveTypeEnum.interactiveLive
        : typeEnum = InteractiveTypeEnum.interactivePK;
    widget.store.state.interactiveTypeEnum = typeEnum;
    widget.store.state.appId = widget.interactiveInfoMap![interactiveAppIdKey];
    widget.store.state.appKey =
        widget.interactiveInfoMap![interactiveAppKeyKey];
    widget.store.state.playDomain =
        widget.interactiveInfoMap![interactivePlayDomainKey];
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: buildAppBar(
        AppLocalizations.of(context)!.interactive_application_information,
        leadingClickListener: () {
          widget.store.dispatch(InteractiveInfoActionCreator.clickGoBack());
        },
      ),
      body: Container(
        color: Colors.black,
        child: Container(
          margin: const EdgeInsets.only(left: 20, right: 20),
          child: Stack(
            children: [
              StreamBuilder<InteractiveInfoState>(
                stream: widget.store.onChange,
                initialData: widget.store.state,
                builder: (context, snapshot) {
                  return _buildInputView(context);
                },
              ),
              StreamBuilder<InteractiveInfoState>(
                stream: widget.store.onChange,
                initialData: widget.store.state,
                builder: (context, snapshot) {
                  return _buildBottomButton(context);
                },
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildInputView(BuildContext context) {
    return SizedBox.expand(
      child: SingleChildScrollView(
        child: Column(
          children: [
            const SizedBox(height: 40),
            InteractiveInputView(
              title: AppLocalizations.of(context)!.interactive_app_id,
              hint:
                  AppLocalizations.of(context)!.interactive_input_number_digits,
              text: widget.store.state.appId,
              action: (text) => widget.store.dispatch(
                InteractiveInfoActionCreator.changeAppId(text),
              ),
            ),
            const SizedBox(height: 20),
            InteractiveInputView(
              title: AppLocalizations.of(context)!.interactive_app_key,
              hint:
                  AppLocalizations.of(context)!.interactive_input_number_digits,
              text: widget.store.state.appKey,
              action: (text) => widget.store.dispatch(
                InteractiveInfoActionCreator.changeAppKey(text),
              ),
            ),
            const SizedBox(height: 20),
            InteractiveInputView(
              title: AppLocalizations.of(context)!.interactive_play_domain,
              hint:
                  AppLocalizations.of(context)!.interactive_input_number_digits,
              text: widget.store.state.playDomain,
              action: (text) => widget.store.dispatch(
                InteractiveInfoActionCreator.changePlayDomain(text),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildBottomButton(BuildContext context) {
    return Positioned(
      left: 0,
      right: 0,
      bottom: 20,
      child: PushButton(
        title: AppLocalizations.of(context)!.interactive_next_button,
        enable: widget.store.state.appId.isNotEmpty &&
            widget.store.state.appKey.isNotEmpty &&
            widget.store.state.playDomain.isNotEmpty,
        action: () => widget.store.dispatch(
          InteractiveInfoActionCreator.clickNext(),
        ),
      ),
    );
  }
}
