// Copyright © 2025 Alibaba Cloud. All rights reserved.
//
// Author: keria
// Date: 2025/1/16
// Brief:

import 'actions.dart';
import 'state.dart';

InteractiveInfoState interactiveInfoReducer(
  InteractiveInfoState state,
  dynamic action,
) {
  if (action is InteractiveInfoAction) {
    switch (action.type) {
      case InteractiveInfoActionType.changeAppId:
        state.appId = action.payload;
        break;
      case InteractiveInfoActionType.changeAppKey:
        state.appKey = action.payload;
        break;
      case InteractiveInfoActionType.changePlayDomain:
        state.playDomain = action.payload;
        break;
      default:
    }
  }
  return state;
}
