import 'package:flutter_livepush_demo/page/interactive_mode/state.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/2/11 09:45
 * @brief
 */

//
enum InteractiveModeActionType {
  init,
  pageDidAppear,
  startPreview,
  clickBtnLink,
  updatePushStatus,
  updatePullStatus,
  updateCustomerInfo,
  updateCDNPlayerViewId,
  startLink,
  stopLink,
  clickSwitchCamera,
  clickMute,
  clickSwitchSpeaker,
  clickNext,
  goBackPage
}

class InteractiveModeAction {
  final InteractiveModeActionType type;
  final dynamic payload;

  InteractiveModeAction(this.type, {this.payload});
}

class InteractiveModeActionCreator {
  static InteractiveModeAction init(context) =>
      InteractiveModeAction(InteractiveModeActionType.init, payload: context);

  static InteractiveModeAction pageDidAppear(appear) =>
      InteractiveModeAction(InteractiveModeActionType.pageDidAppear,
          payload: appear);

  static InteractiveModeAction startPreview() =>
      InteractiveModeAction(InteractiveModeActionType.startPreview);

  static InteractiveModeAction clickBtnLink(isLink) =>
      InteractiveModeAction(InteractiveModeActionType.clickBtnLink,
          payload: isLink);

  static InteractiveModeAction updatePushStatus(
          InteractivePushStatus pushStatus) =>
      InteractiveModeAction(InteractiveModeActionType.updatePushStatus,
          payload: pushStatus);

  static InteractiveModeAction updatePullStatus(
          InteractivePullStatus pullStatus) =>
      InteractiveModeAction(InteractiveModeActionType.updatePullStatus,
          payload: pullStatus);

  static InteractiveModeAction updateCustomerInfo(
          InteractiveCustomerInfo customerInfo) =>
      InteractiveModeAction(InteractiveModeActionType.updateCustomerInfo,
          payload: customerInfo);

  static InteractiveModeAction updateCDNPlayerViewId(int viewId) =>
      InteractiveModeAction(InteractiveModeActionType.updateCDNPlayerViewId,
          payload: viewId);

  static InteractiveModeAction startLink() =>
      InteractiveModeAction(InteractiveModeActionType.startLink);

  static InteractiveModeAction stopLink() =>
      InteractiveModeAction(InteractiveModeActionType.stopLink);

  static InteractiveModeAction clickSwitchCamera() =>
      InteractiveModeAction(InteractiveModeActionType.clickSwitchCamera);

  static InteractiveModeAction clickMute(bool mute) =>
      InteractiveModeAction(InteractiveModeActionType.clickMute, payload: mute);

  static InteractiveModeAction clickSwitchSpeaker() =>
      InteractiveModeAction(InteractiveModeActionType.clickSwitchSpeaker);

  static InteractiveModeAction clickNext() =>
      InteractiveModeAction(InteractiveModeActionType.clickNext);

  static InteractiveModeAction goBackPage() =>
      InteractiveModeAction(InteractiveModeActionType.goBackPage);
}
