import 'actions.dart';
import 'state.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/2/11 09:46
 * @brief
 */

InteractiveModeState interactiveModeReducer(
  InteractiveModeState state,
  action,
) {
  if (action is InteractiveModeAction) {
    switch (action.type) {
      case InteractiveModeActionType.clickNext:
        break;
      case InteractiveModeActionType.clickBtnLink:
        state.isClickLink = action.payload;
        break;
      case InteractiveModeActionType.updatePushStatus:
        state.pushStatus = action.payload;
        break;
      case InteractiveModeActionType.updatePullStatus:
        state.pullStatus = action.payload;
        break;
      case InteractiveModeActionType.updateCustomerInfo:
        state.customerInfo = action.payload;
        break;
      case InteractiveModeActionType.updateCDNPlayerViewId:
        state.cdnPlayerViewId = action.payload;
        break;
      case InteractiveModeActionType.pageDidAppear:
        state.pageDidAppear = action.payload;
        break;
      default:
        break;
    }
  }
  return state;
}
