import 'package:flutter/cupertino.dart';
import 'package:flutter_livepush_plugin/pusher/live_push_config.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/2/11 09:46
 * @brief
 */
enum InteractivePushStatus {
  none,
  pushing,
  pause,
  error,
  stop,
}

enum InteractivePullStatus {
  none,
  pulling,
  pause,
  error,
  stop,
}

class InteractiveCustomerInfo {
  String userId = "";
  String roomId = "";

  static InteractiveCustomerInfo create({String? userId, String? roomId}) {
    InteractiveCustomerInfo info = InteractiveCustomerInfo();
    info.userId = userId ?? "";
    info.roomId = roomId ?? "";
    return info;
  }
}

class InteractiveModeState {
  late BuildContext context;
  String typeEnum;
  String identityTypeEnum;
  String appId;
  String appKey;
  String playDomain;
  String userId;
  String roomId;
  bool pageDidAppear;
  AlivcLivePushConfig pusherConfig = AlivcLivePushConfig.init();
  bool isClickLink;
  InteractivePushStatus pushStatus = InteractivePushStatus.none;
  InteractivePullStatus pullStatus = InteractivePullStatus.none;
  InteractiveCustomerInfo customerInfo = InteractiveCustomerInfo.create();
  int cdnPlayerViewId;
  bool mute;

  InteractiveModeState(
      {this.typeEnum = "interactiveLive",
      this.identityTypeEnum = "anchor",
      this.appId = "",
      this.appKey = "",
      this.playDomain = "",
      this.userId = "",
      this.roomId = "0",
      this.pageDidAppear = false,
      this.isClickLink = false,
      this.cdnPlayerViewId = 0,
      this.mute = false});
}
