import 'package:flutter_livepush_demo/page/push_config/state.dart';
import 'package:redux/redux.dart';

import 'actions.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/1/20 09:53
 * @brief
 */

// middleware.dart
List<Middleware<ConfigState>> createPushConfigMiddlewares() {
  return [
    TypedMiddleware<ConfigState, ConfigAction>(_receiveActions),
  ];
}

void _receiveActions(
  Store<ConfigState> store,
  ConfigAction action,
  NextDispatcher next,
) {
  if (action.type == ConfigActionType.initState) {
    _initState(store);
  }
  next(action);
}

Future<void> _initState(
  Store<ConfigState> store,
) async {}
