import 'package:flutter/cupertino.dart';
import 'package:flutter_livepush_demo/manager/push_config_manager.dart';
import 'package:flutter_livepush_plugin/pusher/live_push_config.dart';

/**
 * Copyright © 2025 Alibaba Cloud. All rights reserved.
 * @author junhuiYe
 * @date 2025/1/20 09:52
 * @brief
 */
typedef OnSettingConfigAction = void Function(AlivcLivePushConfig pusherConfig);

class ConfigState {
  late BuildContext mContext;
  bool openAdvanced = false;
  ConfigData configData = ConfigData();
  PushConfigPageType pageType = PushConfigPageType.basic;
  ConfigState? pushConfigState;
  OnSettingConfigAction? onSettingConfigAction;

  @override
  ConfigState clone() => ConfigState()
    ..configData = configData
    ..pageType = pageType
    ..pushConfigState = pushConfigState;
}
