import 'package:flutter/material.dart';
import 'package:mobile_scanner/mobile_scanner.dart';

/**
 * 扫码
 */
class QRScannerPage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text("QR Code Scanner")),
      body: Stack(
        children: [
          MobileScanner(
            onDetect: (barcode, args) {
              if (barcode.rawValue != null) {
                // 扫描到二维码后，返回结果
                Navigator.pop(context, barcode.rawValue);
              }
            },
          ),
          // 自定义扫码范围，可通过 Positioned 组件设置
          Positioned(
            left: 40.0,
            top: 100.0,
            width: 300.0,
            // 框的宽度
            height: 300.0,
            // 框的高度
            child: Container(
              decoration: BoxDecoration(
                border: Border.all(color: Colors.red, width: 2),
                borderRadius: BorderRadius.circular(10),
              ),
              // 如果需要可以加入透明填充色
              // color: Colors.red.withOpacity(0.2),
            ),
          ),
          // 可以添加提示文本，帮助用户对准扫码区域
          const Positioned(
            top: 50.0,
            left: 100.0,
            right: 100.0,
            child: Text(
              '请将二维码放入框内',
              textAlign: TextAlign.center,
              style: TextStyle(color: Colors.white, fontSize: 16),
            ),
          )
        ],
      ),
    );
  }
}
