import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/common/common_util.dart';
import 'package:flutter_livepush_demo/model/music_info.dart';
import 'package:flutter_livepush_demo/page/camera_push/actions.dart';
import 'package:flutter_livepush_demo/page/camera_push/state.dart';
import 'config_cell.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';
import 'package:redux/redux.dart';

String _muteAssets = "assets/images/ic_mute_off.png";
String _playAssets = "assets/images/ic_music_pause.png";
String _loopAssets = "assets/images/ic_loop_off.png";

Widget bottomSheetMusic(
    context, CameraPushState state, Store<CameraPushState> store) {
  return Container(
    clipBehavior: Clip.antiAlias,
    decoration: const BoxDecoration(
      color: Color(0xff1C1D22),
      borderRadius: BorderRadius.only(
        topLeft: Radius.circular(20.0),
        topRight: Radius.circular(20.0),
      ),
    ),
    height: MediaQuery.of(context).size.height - 50.0,
    padding: EdgeInsets.only(
      left: MediaQuery.of(context).padding.left,
      right: MediaQuery.of(context).padding.right,
    ),
    child: Column(
      children: [
        _musicHeader(context, state, store),
        const Divider(height: 1.0),
        ConfigCell(
          type: ConfigCellType.switchSelect,
          title: AppLocalizations.of(context)!
              .camerapush_music_enable_in_ear_monitoring,
          defaultValue: state.bgmState.isOpenBGMEarsBack,
          action: (value) {
            store.dispatch(
                CameraPushBGMAction(CameraPushBGMActionType.changeEars, payload: value));
          },
        ),
        ConfigCell(
          type: ConfigCellType.switchSelect,
          title: AppLocalizations.of(context)!.camerapush_music_noise_reduction,
          defaultValue: state.bgmState.isOpenAudioDenoise,
          action: (value) {
            store.dispatch(CameraPushBGMAction(
                CameraPushBGMActionType.changeAudioDenoise,
                payload: value));
          },
        ),
        Expanded(
          child: ListView.builder(
            itemBuilder: (BuildContext context, int index) {
              if (index == 0) {
                return _buildMusicListControlItem(context, state, store);
              } else {
                return _buildMusicListNormalItem(
                    state, context, musicList, index - 1, store);
              }
            },
            itemCount: musicList.length + 1,
          ),
        ),
      ],
    ),
  );
}

Widget _musicHeader(
    context, CameraPushState state, Store<CameraPushState> store) {
  return SizedBox(
    height: 40,
    child: Stack(
      textDirection: TextDirection.rtl,
      children: [
        Center(
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceAround,
            children: [
              InkWell(
                onTap: () {
                  store.dispatch(CameraPushBottomSheetAction(
                      CameraPushBottomSheetActionType.hideMusic,
                      payload: CameraPushPageBottomSheetState.nothing));
                },
                child: Text(
                  AppLocalizations.of(context)!.config_cell_cancel_button,
                  style: const TextStyle(
                    fontSize: 15,
                    color: Color(0xFFFCFCFD),
                  ),
                ),
              ),
              Text(
                AppLocalizations.of(context)!.camerapush_music,
                style: const TextStyle(
                  fontSize: 15,
                  color: Color(0xFFFCFCFD),
                ),
              ),
              InkWell(
                onTap: () {
                  store.dispatch(CameraPushBottomSheetAction(
                      CameraPushBottomSheetActionType.hideMusic,
                      payload: CameraPushPageBottomSheetState.nothing));
                },
                child: Text(
                  AppLocalizations.of(context)!.config_cell_ok_button,
                  style: const TextStyle(
                    fontSize: 15,
                    color: Color(0xFF4DCFE1),
                  ),
                ),
              ),
            ],
          ),
        ),
      ],
    ),
  );
}

bool bgmMute = false;

Widget _buildMusicListControlItem(
    context, CameraPushState state, Store<CameraPushState> store) {
  if (state.bgmState.isBGMMute) {
    _muteAssets = "assets/images/ic_mute_on.png";
  } else {
    _muteAssets = "assets/images/ic_mute_off.png";
  }
  if (state.bgmState.isBGMPlaying) {
    _playAssets = "assets/images/ic_music_pause.png";
  } else {
    _playAssets = "assets/images/ic_music_play.png";
  }
  if (state.bgmState.isBGMLoop) {
    _loopAssets = "assets/images/ic_loop_on.png";
  } else {
    _loopAssets = "assets/images/ic_loop_off.png";
  }
  return Container(
    margin: const EdgeInsets.all(20),
    padding: const EdgeInsets.all(10),
    clipBehavior: Clip.antiAlias,
    decoration: const BoxDecoration(
      color: Color(0xFF1C1D22),
      borderRadius: BorderRadius.all(
        Radius.circular(20.0),
      ),
    ),
    child: Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              AppLocalizations.of(context)!.camerapush_music_item(
                  musicList[state.bgmState.bgmSelectedIndex].name),
              style: const TextStyle(
                fontSize: 16,
                color: Color(0xFFFCFCFD),
              ),
            ),
            Image.asset(
              "assets/images/ic_ugsv_music_yinfu.png",
              width: 16,
              height: 16,
            ),
          ],
        ),
        const SizedBox(height: 20.0),
        Slider(
          min: 0.0,
          max: state.bgmState.bgmDuration.toDouble(),
          value: state.bgmState.bgmProgress.toDouble(),
          onChanged: (double value) {},
        ),
        const SizedBox(height: 20.0),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            GestureDetector(
              onTap: (() {
                store.dispatch(CameraPushBGMAction(
                    CameraPushBGMActionType.changeMute,
                    payload: !state.bgmState.isBGMMute));
              }),
              child: Image.asset(
                _muteAssets,
                width: 28,
                height: 28,
              ),
            ),
            GestureDetector(
              onTap: (() {
                store.dispatch(CameraPushBGMAction(
                    CameraPushBGMActionType.changePlayState,
                    payload: !state.bgmState.isBGMPlaying));
              }),
              child: Image.asset(
                _playAssets,
                width: 28,
                height: 28,
              ),
            ),
            GestureDetector(
              onTap: (() {
                store.dispatch(CameraPushBGMAction(
                    CameraPushBGMActionType.changeLoop,
                    payload: !state.bgmState.isBGMLoop));
              }),
              child: Image.asset(
                _loopAssets,
                width: 28,
                height: 28,
              ),
            ),
          ],
        ),
        const SizedBox(height: 20.0),
        Text(
          AppLocalizations.of(context)!.camerapush_music_accompaniment_volume,
          style: const TextStyle(
            fontSize: 15,
            color: Color(0xFFFCFCFD),
          ),
        ),
        Slider(
            min: 0,
            max: 100,
            value: state.bgmState.bgmVolume.toDouble(),
            onChanged: (value) {
              store.dispatch(CameraPushBGMAction(
                  CameraPushBGMActionType.changeBGMVolume,
                  payload: value.toInt()));
            }),
        Text(
          AppLocalizations.of(context)!.camerapush_music_vocal_volume,
          style: const TextStyle(
            fontSize: 15,
            color: Color(0xFFFCFCFD),
          ),
        ),
        Slider(
          min: 0,
          max: 100,
          value: state.bgmState.bgmCaptureVolume.toDouble(),
          onChanged: (value) {
            store.dispatch(CameraPushBGMAction(
                CameraPushBGMActionType.changeCaptureVolume,
                payload: value.toInt()));
          },
        ),
      ],
    ),
  );
}

Widget _buildMusicListNormalItem(CameraPushState state, BuildContext context,
    List<MusicInfo> datas, int index, Store<CameraPushState> store) {
  Widget selectImg = const SizedBox();
  if (state.bgmState.bgmSelectedIndex == index) {
    selectImg = Image.asset(
      "assets/images/ic_check.png",
      width: 22,
      height: 22,
    );
  } else {
    selectImg = const SizedBox();
  }
  return GestureDetector(
    onTap: () {
      MusicInfo selectMusicInfo = datas[index].clone();
      store.dispatch(CameraPushBGMAction(
          CameraPushBGMActionType.changeBGMSource,
          payload: selectMusicInfo));
    },
    child: SizedBox(
      height: 45,
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text(
                AppLocalizations.of(context)!
                    .camerapush_music_item(datas[index].name),
                style: const TextStyle(
                  fontSize: 15,
                  color: Color(0xFFFCFCFD),
                ),
              ),
              selectImg,
            ],
          ),
          const Divider(height: 5.0),
        ],
      ),
    ),
  );
}
