import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/manager/push_config_manager.dart';
import 'package:flutter_livepush_demo/page/camera_push/actions.dart';
import 'package:flutter_livepush_demo/page/camera_push/state.dart';
import 'config_cell.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';
import 'package:redux/redux.dart';

Widget showSetting(
    context, CameraPushState state, Store<CameraPushState> store) {
  return Container(
    clipBehavior: Clip.antiAlias,
    decoration: const BoxDecoration(
      color: Color(0xff1C1D22),
      borderRadius: BorderRadius.only(
        topLeft: Radius.circular(20.0),
        topRight: Radius.circular(20.0),
      ),
    ),
    height: MediaQuery.of(context).size.height - 200,
    padding: EdgeInsets.only(
      left: MediaQuery.of(context).padding.left,
      right: MediaQuery.of(context).padding.right,
    ),
    child: Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        _showSettingHead(context, state, store),
        const Divider(height: 1.0),
        Expanded(
          child: _showSettingContent(context, state, store),
        ),
      ],
    ),
  );
}

Widget _showSettingHead(
    context, CameraPushState state, Store<CameraPushState> store) {
  return SizedBox(
    height: 40,
    child: Stack(
      textDirection: TextDirection.rtl,
      children: [
        Center(
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceAround,
            children: [
              InkWell(
                onTap: (() => store.dispatch(CameraPushBottomSheetAction(
                    CameraPushBottomSheetActionType.hideMusic,
                    payload: CameraPushPageBottomSheetState.nothing))),
                child: Text(
                  AppLocalizations.of(context)!.config_cell_cancel_button,
                  style: const TextStyle(
                    fontSize: 15,
                    color: Color(0xFFFCFCFD),
                  ),
                ),
              ),
              Text(
                AppLocalizations.of(context)!.camerapush_more_setting,
                style: const TextStyle(
                  fontSize: 15,
                  color: Color(0xFFFCFCFD),
                ),
              ),
              InkWell(
                onTap: () {
                  store.dispatch(CameraPushConfigAction(
                      CameraPushConfigActionType.setTargetVideoBitrate,
                      payload: state.pushSettingState.videoTargetBitrate));
                  store.dispatch(CameraPushConfigAction(
                      CameraPushConfigActionType.setMinVideoBitrate,
                      payload: state.pushSettingState.videoMinBitrate));

                  store.dispatch(CameraPushBottomSheetAction(
                      CameraPushBottomSheetActionType.hideMusic,
                      payload: CameraPushPageBottomSheetState.nothing));
                },
                child: Text(
                  AppLocalizations.of(context)!.config_cell_ok_button,
                  style: const TextStyle(
                    fontSize: 15,
                    color: Color(0xFF4DCFE1),
                  ),
                ),
              )
            ],
          ),
        ),
      ],
    ),
  );
}

Widget _showSettingContent(
    context, CameraPushState state, Store<CameraPushState> store) {
  return ListView(
    children: [
      ConfigCell(
        type: ConfigCellType.input,
        title: AppLocalizations.of(context)!.config_target_bitrate,
        infoUnit: "/Kbps",
        defaultValue: state.pushSettingState.videoTargetBitrate.toString(),
        action: (value) {
          store.dispatch(CameraPushConfigAction(
              CameraPushConfigActionType.setTargetVideoBitrate,
              payload: int.parse(value)));
        },
      ),
      ConfigCell(
        type: ConfigCellType.input,
        title: AppLocalizations.of(context)!.config_min_bitrate,
        infoUnit: "/Kbps",
        defaultValue: state.pushSettingState.videoMinBitrate.toString(),
        action: (value) {
          store.dispatch(CameraPushConfigAction(
              CameraPushConfigActionType.setMinVideoBitrate,
              payload: int.parse(value)));
        },
      ),
      ConfigCell(
        type: ConfigCellType.switchSelect,
        title: AppLocalizations.of(context)!.config_push_mirror,
        defaultValue: state.pushSettingState.isOpenPushMirror,
        action: (value) {
          store.dispatch(CameraPushConfigAction(
              CameraPushConfigActionType.changePushMirror,
              payload: value));
        },
      ),
      ConfigCell(
        type: ConfigCellType.switchSelect,
        title: AppLocalizations.of(context)!.config_preview_mirror,
        defaultValue: state.pushSettingState.isOpenPreviewMirror,
        action: (value) {
          store.dispatch(CameraPushConfigAction(
              CameraPushConfigActionType.changePreviewMirror,
              payload: value));
        },
      ),
      ConfigCell(
        type: ConfigCellType.pickerSelect,
        title: AppLocalizations.of(context)!.config_preview_display_mode,
        pickerPanelTexts: previewDisplayModeItems.values.toList(),
        defaultValue: previewDisplayModeItems.values
            .toList()[state.pushSettingState.previewModelIndex],
        action: (value) {
          store.dispatch(CameraPushConfigAction(
              CameraPushConfigActionType.setPreviewDisplayMode,
              payload: value.index));
        },
      ),
    ],
  );
}
