import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';

showAlert(
  BuildContext context,
  String message, {
  String? title,
  Function? onCancel,
  Function? onOk,
}) {
  showCupertinoDialog(
      context: context,
      builder: (context) {
        return Theme(
            data: ThemeData.dark(),
            child: CupertinoAlertDialog(
              title: Text(
                  title ?? AppLocalizations.of(context)!.common_alert_note),
              content: Text(message),
              actions: [
                CupertinoDialogAction(
                  child: Text(
                    AppLocalizations.of(context)!.config_cell_cancel_button,
                    style: const TextStyle(color: Colors.white),
                  ),
                  onPressed: () {
                    Navigator.of(context).pop();
                    onCancel?.call();
                  },
                ),
                CupertinoDialogAction(
                  child: Text(
                    AppLocalizations.of(context)!.config_cell_ok_button,
                    style: const TextStyle(color: Colors.white),
                  ),
                  onPressed: () {
                    Navigator.of(context).pop();
                    onOk?.call();
                  },
                ),
              ],
            ));
      });
}

Widget positionedView({
  Widget? child,
  double? left,
  double? right,
  double? top,
  double? bottom,
  double? width,
  double? height,
  Color? color,
}) {
  return Positioned(
    left: left,
    right: right,
    top: top,
    bottom: bottom,
    width: width,
    height: height,
    child: Container(
      width: width,
      height: height,
      color: color,
      child: child,
    ),
  );
}
