import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_livepush_demo/page/qrcode/qr_scanner_page.dart';

typedef void ConfigInputURLViewActionCallback(value);

class ConfigInputURLView extends StatefulWidget {
  final String? defaultText;
  final String? placeholder;
  final ConfigInputURLViewActionCallback? action;

  ConfigInputURLView(
      {Key? key, this.defaultText, this.placeholder, this.action});

  @override
  State<StatefulWidget> createState() => _ConfigInputURLViewState();
}

class _ConfigInputURLViewState extends State<ConfigInputURLView> {
  TextEditingController _inputController = TextEditingController();
  FocusNode _userFocusNode = FocusNode();

  @override
  void initState() {
    super.initState();

    if (widget.defaultText != null) {
      _inputController.text = widget.defaultText!;
    }

    _inputController.addListener(() {
      if (widget.action != null) {
        widget.action!(_inputController.text);
      }
    });
  }

  @override
  void dispose() {
    _inputController.dispose();
    _userFocusNode.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 64,
      padding: const EdgeInsets.only(top: 5, bottom: 5),
      child: TextField(
        textAlign: TextAlign.left,
        style: const TextStyle(fontSize: 15, color: Colors.white),
        controller: _inputController,
        keyboardType: TextInputType.emailAddress,
        focusNode: _userFocusNode,
        decoration: InputDecoration(
            icon: IconButton(
              icon: Image.asset(
                "assets/images/ic_scan.png",
                width: 16,
                height: 16,
              ),
              onPressed: () => _getQrcodeState(),
            ),
            hintText: widget.placeholder,
            hintStyle: const TextStyle(fontSize: 12, color: Colors.grey),
            border: InputBorder.none),
      ),
    );
  }

  _getQrcodeState() async {
    // 导航到二维码扫描页面
    final result = await Navigator.push(
      context,
      MaterialPageRoute(builder: (context) => QRScannerPage()),
    );
    if (mounted) {
      if (result != null) {
        setState(() {
          _inputController.text = result;
        });
      }
    }
  }
}
