import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/manager/push_config_manager.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';

typedef void ConfigSegmentBarActionCallback(value);

class ConfigSegmentBar extends StatefulWidget {
  final List<ConfigSegmentBarItemData> item;
  final double? fontSize;
  final Color? normalTitleColor;
  final Color? selectedTitleColor;
  final int? selectIndex;
  final ConfigSegmentBarActionCallback? action;

  ConfigSegmentBar(
      {Key? key,
      required this.item,
      this.fontSize,
      this.normalTitleColor,
      this.selectedTitleColor,
      this.selectIndex,
      this.action})
      : assert(item != null),
        super(key: key);

  @override
  State<StatefulWidget> createState() => _ConfigSegmentBarState();
}

class _ConfigSegmentBarState extends State<ConfigSegmentBar> {
  var _selectIndex_temp = 0;

  @override
  void initState() {
    super.initState();

    if (widget.selectIndex != null) {
      _selectIndex_temp = widget.selectIndex!;
    }
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    double itemWidth = 75;
    final width = MediaQuery.of(context).size.width;
    if (widget.item.length * itemWidth < width) {
      itemWidth = width / widget.item.length;
    }
    return Container(
      height: 44,
      child: ListView.builder(
        scrollDirection: Axis.horizontal,
        itemCount: widget.item.length,
        itemExtent: itemWidth,
        itemBuilder: (context, index) {
          return InkWell(
            onTap: () {
              setState(() {
                _selectIndex_temp = index;
              });
              if (widget.action != null) {
                widget.action!(index);
              }
            },
            child: _itemContainer(context, index),
          );
        },
      ),
    );
  }

  Widget _itemContainer(BuildContext context, int index) {
    ConfigSegmentBarItemData itemData = widget.item[index];
    Color titleColor = Colors.white;
    double titleFontSize = 12;
    FontWeight fontWeight = FontWeight.normal;
    if (widget.fontSize != null) {
      titleFontSize = widget.fontSize!;
    }
    if (index == _selectIndex_temp) {
      if (widget.selectedTitleColor != null) {
        titleColor = widget.selectedTitleColor!;
      } else {
        fontWeight = FontWeight.bold;
      }
    } else {
      if (widget.normalTitleColor != null) {
        titleColor = widget.normalTitleColor!;
      }
    }

    if (itemData.icon.length > 0) {
      String iconName = itemData.icon;
      if (index == _selectIndex_temp) {
        if (itemData.selectedIcon.length > 0) {
          iconName = itemData.selectedIcon;
        }
      }
      return Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          _iconRenderView(iconName),
          const SizedBox(
            height: 8,
          ),
          _titleRenderView(
              context, itemData.title, titleColor, titleFontSize, fontWeight)
        ],
      );
    } else {
      return Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          _titleRenderView(
              context, itemData.title, titleColor, titleFontSize, fontWeight)
        ],
      );
    }
  }

  Widget _iconRenderView(String iconName) {
    return Image.asset(
      iconName,
      width: 16,
      height: 16,
    );
  }

  Widget _titleRenderView(BuildContext context, String text, Color color,
      double fontSize, FontWeight fontWeight) {
    return Text(
      AppLocalizations.of(context)!.config_segment_item(text),
      textAlign: TextAlign.center,
      style:
          TextStyle(color: color, fontSize: fontSize, fontWeight: fontWeight),
    );
  }
}
