import 'package:flutter/material.dart';
import 'package:flutter_livepush_demo/page/qrcode/qr_scanner_page.dart';

typedef void InteractiveInputChangedListener(value);

class InteractiveInputView extends StatefulWidget {
  String title;
  String hint;
  String text;
  bool onlyClearIcon;
  InteractiveInputChangedListener? action;

  InteractiveInputView(
      {Key? key,
      this.title = "",
      this.hint = "",
      this.text = "",
      this.action,
      this.onlyClearIcon = false})
      : super(key: key);

  @override
  State<InteractiveInputView> createState() => _InteractiveInputViewState();
}

class _InteractiveInputViewState extends State<InteractiveInputView> {
  final TextEditingController _inputController = TextEditingController();

  @override
  void initState() {
    super.initState();
    _inputController.addListener(() {
      setState(() {});
      widget.action?.call(_inputController.text);
    });
    _inputController.text = widget.text;
  }

  @override
  void dispose() {
    super.dispose();
    _inputController.removeListener(() {});
  }

  @override
  Widget build(BuildContext context) {
    var imgPath = _inputController.text.isEmpty && !widget.onlyClearIcon
        ? "assets/images/ic_scan.png"
        : "assets/images/ic_close.png";
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          widget.title,
          style: const TextStyle(color: Colors.white),
        ),
        const SizedBox(height: 10),
        TextField(
          maxLines: 1,
          textAlign: TextAlign.left,
          style: const TextStyle(color: Colors.white),
          controller: _inputController,
          decoration: InputDecoration(
            suffixIcon: IconButton(
              icon: Image.asset(
                imgPath,
                width: 16,
                height: 16,
              ),
              onPressed: () {
                if (mounted) {
                  setState(() {
                    if (_inputController.text.isEmpty &&
                        !widget.onlyClearIcon) {
                      _getQrcodeState();
                    } else {
                      _inputController.text = "";
                    }
                  });
                }
              },
            ),
            focusedBorder: const UnderlineInputBorder(
              borderSide: BorderSide(
                color: Color(0xFFE6E7EC),
              ),
            ),
            enabledBorder: const UnderlineInputBorder(
              borderSide: BorderSide(
                color: Color(0xFFE6E7EC),
              ),
            ),
            counterText: '',
            hintText: widget.hint,
            hintStyle: const TextStyle(color: Colors.white),
          ),
        ),
      ],
    );
  }

  _getQrcodeState() async {
    // 导航到二维码扫描页面
    final result = await Navigator.push(
      context,
      MaterialPageRoute(builder: (context) => QRScannerPage()),
    );
    if (mounted) {
      if (result != null) {
        setState(() {
          _inputController.text = result;
        });
      }
    }
  }
}
