import 'package:flutter/material.dart';
import 'package:flutter_gen/gen_l10n/app_localizations.dart';

class InteractiveMeetingInfoDialog extends Dialog {
  bool onlyUserId;
  Function? onConfirm;
  final TextEditingController _userIdController = TextEditingController();
  final TextEditingController _roomIdController = TextEditingController();

  InteractiveMeetingInfoDialog(
      {Key? key, this.onlyUserId = true, this.onConfirm})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Material(
      type: MaterialType.transparency,
      child: _buildDialogContent(context),
    );
  }

  Widget _buildDialogContent(BuildContext context) {
    var width = MediaQuery.of(context).size.width;
    var height = MediaQuery.of(context).size.height;
    double reactHeight = height / 2 - 100;
    if (onlyUserId) {
      reactHeight = height / 2 - 200;
    }
    return UnconstrainedBox(
      child: Container(
        width: width - 50,
        height: reactHeight,
        decoration: BoxDecoration(
          shape: BoxShape.rectangle,
          color: const Color(0xFF23262F),
          borderRadius: BorderRadius.circular(16.0),
        ),
        child: Stack(
          children: [
            _buildUserIdAndRoomId(width),
            _buildBottomButton(context),
          ],
        ),
      ),
    );
  }

  Widget _buildUserIdAndRoomId(double width) {
    return Positioned(
      top: 40,
      left: 10,
      right: 10,
      child: Column(
        children: [
          Offstage(
            offstage: false,
            child: SizedBox(
              width: width - 100,
              height: 35,
              child: _buildCustomTextField("user Id", _userIdController),
            ),
          ),
          const SizedBox(height: 20),
          Offstage(
            offstage: onlyUserId,
            child: SizedBox(
              width: width - 100,
              height: 35,
              child: _buildCustomTextField("room Id", _roomIdController),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildBottomButton(BuildContext context) {
    return Positioned(
      left: 0,
      right: 0,
      bottom: 0,
      child: Column(
        children: [
          const Divider(
            height: 1,
            color: Colors.grey,
          ),
          SizedBox(
            width: double.infinity,
            height: 49,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                TextButton(
                  onPressed: () {
                    Navigator.of(context).pop();
                  },
                  child: Text(
                    AppLocalizations.of(context)!.config_cell_cancel_button,
                    style: const TextStyle(color: Colors.white),
                  ),
                ),
                const VerticalDivider(width: 1, color: Colors.white),
                TextButton(
                  onPressed: () {
                    onConfirm?.call(
                        _userIdController.text, _roomIdController.text);
                    Navigator.of(context).pop();
                  },
                  child: Text(
                    AppLocalizations.of(context)!.config_cell_ok_button,
                    style: const TextStyle(color: Colors.blue),
                  ),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildCustomTextField(
      String hintStr, TextEditingController controller) {
    return TextField(
      style: const TextStyle(
        fontSize: 16,
        color: Color(0xFFE6E7EC),
      ),
      maxLines: 1,
      controller: controller,
      decoration: InputDecoration(
        suffixIcon: IconButton(
          onPressed: () {
            controller.clear();
          },
          icon: Image.asset("assets/images/ic_close.png"),
        ),
        hintText: hintStr,
        contentPadding: const EdgeInsets.all(10),
        hintMaxLines: 1,
        hintStyle: const TextStyle(
          color: Color(0xFFE6E7EC),
        ),
        enabledBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(
            Radius.circular(5.0),
          ),
          borderSide: BorderSide(
              color: Color(0xFF747A8C), width: 1.0, style: BorderStyle.solid),
        ),
        focusedBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(
            Radius.circular(5.0),
          ),
          borderSide: BorderSide(
              color: Color(0xFF747A8C), width: 1.0, style: BorderStyle.solid),
        ),
      ),
    );
  }
}
