package com.alivc.queen;

import android.content.Context;

import androidx.annotation.NonNull;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;

/** FlutterAliyunqueenPlugin */
public class FlutterAliyunqueenPlugin extends PlatformViewFactory implements FlutterPlugin, MethodCallHandler {
  /// The MethodChannel that will the communication between Flutter and native Android
  ///
  /// This local reference serves to register the plugin with the Flutter Engine and unregister it
  /// when the Flutter Engine is detached from the Activity
  private MethodChannel channel;
  private FlutterAliyunQueenMenuPanel flutterAliyunQueenMenuPanel;

  public FlutterAliyunqueenPlugin() {
    super(StandardMessageCodec.INSTANCE);
  }


  @Override
  public void onAttachedToEngine(@NonNull FlutterPluginBinding flutterPluginBinding) {

    flutterPluginBinding.getPlatformViewRegistry().registerViewFactory("plugins.aliyunqueen.view", this);

    channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "plugins.livebeauty.method");
    channel.setMethodCallHandler(this);
  }

  @Override
  public void onMethodCall(@NonNull MethodCall call, @NonNull Result result) {
    switch (call.method){
      case "getQueenSDKVersion":
        result.success("");
        break;
      case "setupBeauty":
        break;
      case "showPanel":
        result.success(null);
        break;
      case "destroyBeauty":
        break;
    }
  }

  @Override
  public void onDetachedFromEngine(@NonNull FlutterPluginBinding binding) {
    channel.setMethodCallHandler(null);
  }

  @Override
  public PlatformView create(Context context, int viewId, Object args) {
    flutterAliyunQueenMenuPanel = new FlutterAliyunQueenMenuPanel(context,viewId,args);
    return flutterAliyunQueenMenuPanel;
  }
}
