//
//  AlivcBeautyController.h
//  AlivcLivePusherDemo
//
//  Created by zhangjc on 2022/5/7.
//  Copyright © 2022 TripleL. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, AliLiveBeautyVideoFormat) {
    AliLiveBeautyVideoFormatUnknown   = -1,
    AliLiveBeautyVideoFormatBGR       = 0,
    AliLiveBeautyVideoFormatRGB,
    AliLiveBeautyVideoFormatARGB,
    AliLiveBeautyVideoFormatBGRA,
    AliLiveBeautyVideoFormatRGBA,
    AliLiveBeautyVideoFormatYUV420P,
    AliLiveBeautyVideoFormatYUVYV12,
    AliLiveBeautyVideoFormatYUVNV21,
    AliLiveBeautyVideoFormatYUVNV12,
    AliLiveBeautyVideoFormatYUVJ420P,
    AliLiveBeautyVideoFormatYUVJ420SP,
    AliLiveBeautyVideoFormatYUVJ444P,
    AliLiveBeautyVideoFormatYUV444P,
};

typedef NS_ENUM(NSInteger, AliLiveBeautyOrientation) {
    AliLiveBeautyOrientationPortrait = 0,
    AliLiveBeautyOrientationLandscapeLeft,
    AliLiveBeautyOrientationLandscapeRight,
};

NS_ASSUME_NONNULL_BEGIN

@interface AlivcBeautyController : NSObject

+ (AlivcBeautyController *)sharedInstance;

- (void)setupBeautyController:(BOOL)processPixelBuffer;
- (void)detectVideoBuffer:(long)buffer withWidth:(int)width withHeight:(int)height withVideoFormat:(AliLiveBeautyVideoFormat)videoFormat withPushOrientation:(AliLiveBeautyOrientation)pushOrientation;
- (int)processGLTextureWithTextureID:(int)textureID withWidth:(int)width withHeight:(int)height;
- (BOOL)processPixelBuffer:(CVPixelBufferRef)pixelBufferRef withPushOrientation:(AliLiveBeautyOrientation)pushOrientation;
- (void)destroyBeautyController;

- (void)setupBeautyControllerUIWithView:(UIView *)view;
- (void)showPanel:(BOOL)animated;
- (void)destroyBeautyControllerUI;

+ (NSString *)getQueenSDKVersion;

@end

NS_ASSUME_NONNULL_END
