/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.aliyunplayerbase.bean.AliyunVideoList;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import com.google.zxing.activity.CaptureActivity;
import java.util.List;

public class AliyunPlayerTypeUrlFragment
extends BaseFragment {
    private static final int REQ_CODE_PERMISSION = 4369;
    private EditText mUrlEditText;
    private String mUrlPath;
    private ImageView mQrCodeImageView;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_aliyun_url_player_type, container, false);
        this.mUrlEditText = (EditText)view.findViewById(R.id.et_url);
        this.mQrCodeImageView = (ImageView)view.findViewById(R.id.iv_qrcode);
        this.initData();
        this.initListener();
        if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mUrlPath)) {
            this.defaultPlayInfo();
        }
        return view;
    }

    private void getPlayUrlInfo() {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayUrlInfo(new GetAuthInformation.OnGetUrlInfoListener(){

            public void onGetUrlError(String msg) {
                if (AliyunPlayerTypeUrlFragment.this.getContext() != null) {
                    ToastUtils.show((Context)AliyunPlayerTypeUrlFragment.this.getContext(), (String)msg);
                }
            }

            public void onGetUrlSuccess(AliyunVideoList.VideoList dataBean) {
                List playInfoList;
                if (dataBean != null && (playInfoList = dataBean.getPlayInfoList()) != null && playInfoList.size() > 0) {
                    AliyunVideoList.VideoList.VideoListItem videoListItem = (AliyunVideoList.VideoList.VideoListItem)playInfoList.get(0);
                    AliyunPlayerTypeUrlFragment.this.mUrlEditText.setText((CharSequence)videoListItem.getPlayURL());
                    AliyunPlayerTypeUrlFragment.this.mUrlPath = videoListItem.getPlayURL();
                }
            }
        });
    }

    private void initData() {
        this.mUrlEditText.setText((CharSequence)GlobalPlayerConfig.mUrlPath);
    }

    private void initListener() {
        this.mQrCodeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ContextCompat.checkSelfPermission((Context)AliyunPlayerTypeUrlFragment.this.getActivity(), (String)"android.permission.CAMERA") != 0) {
                    ActivityCompat.requestPermissions((Activity)AliyunPlayerTypeUrlFragment.this.getActivity(), (String[])new String[]{"android.permission.CAMERA"}, (int)4369);
                } else {
                    AliyunPlayerTypeUrlFragment.this.startCaptureActivityForResult();
                }
            }
        });
    }

    @Override
    public void defaultPlayInfo() {
        this.getPlayUrlInfo();
    }

    @Override
    public void confirmPlayInfo() {
        GlobalPlayerConfig.mUrlPath = this.mUrlPath = this.mUrlEditText.getText().toString();
        GlobalPlayerConfig.URL_TYPE_CHECKED = true;
    }

    private void startCaptureActivityForResult() {
        Intent intent = new Intent((Context)this.getActivity(), CaptureActivity.class);
        this.startActivityForResult(intent, 156);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 4369: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCaptureActivityForResult();
                    break;
                }
                ToastUtils.show((Context)this.getActivity(), (String)this.getString(R.string.alivc_player_agree_camera_permission));
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 156: {
                switch (resultCode) {
                    case -1: {
                        this.mUrlEditText.setText((CharSequence)data.getStringExtra("qr_scan_result"));
                        return;
                    }
                    case 0: {
                        if (data == null) return;
                        this.mUrlEditText.setText((CharSequence)data.getStringExtra("qr_scan_result"));
                        return;
                    }
                }
                return;
            }
        }
    }
}

