/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.liveshift;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.aliyun.player.source.LiveShift;
import com.aliyun.sdk.liveshift.bean.TimeLineContent;
import com.aliyun.sdk.liveshift.bean.TimeLineInfo;
import com.aliyun.sdk.liveshift.request.GetTimeShiftRequest;
import com.aliyun.sdk.player.AliLiveShiftPlayer;
import com.aliyun.sdk.utils.BaseRequest;
import java.lang.ref.WeakReference;
import java.util.List;

public class LiveTimeUpdater {
    private static final String TAG = "LiveTimeUpdater";
    private static int WHAT_UPDATE_LIVE_TIME = 0;
    private static int WHAT_UPDATE_PLAY_TIME = 1;
    private final LiveShift mTimeShift;
    private WeakReference<Context> contextWeak;
    private AliLiveShiftPlayer.OnTimeShiftUpdaterListener timeShiftUpdaterListener;
    private long playTime;
    private long liveTime;
    private Handler timer = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == WHAT_UPDATE_LIVE_TIME) {
                LiveTimeUpdater.this.updateLiveTimer();
                LiveTimeUpdater.this.startUpdateLiveTimerDelay(60);
            } else if (msg.what == WHAT_UPDATE_PLAY_TIME) {
                if (!LiveTimeUpdater.this.needPause) {
                    LiveTimeUpdater.this.playTime++;
                }
                LiveTimeUpdater.this.liveTime++;
                LiveTimeUpdater.this.startUpdatePlayTimerDelay(1);
            }
        }
    };
    private boolean needPause = false;

    public LiveTimeUpdater(Context context, LiveShift timeShift) {
        this.contextWeak = new WeakReference<Context>(context);
        this.mTimeShift = timeShift;
    }

    public void setStartPlayTime(long startPlayTime) {
        this.playTime = startPlayTime;
    }

    private void updateLiveTimer() {
        GetTimeShiftRequest request = new GetTimeShiftRequest((Context)this.contextWeak.get(), this.mTimeShift, new BaseRequest.OnRequestListener<TimeLineContent>(){

            @Override
            public void onSuccess(TimeLineContent requestInfo, String requestId) {
                if (LiveTimeUpdater.this.timeShiftUpdaterListener != null) {
                    long currentTime = requestInfo.current;
                    long shiftStartTime = LiveTimeUpdater.this.getStartTime(requestInfo);
                    long shiftEndTime = LiveTimeUpdater.this.getEndTime(requestInfo);
                    LiveTimeUpdater.this.liveTime = currentTime;
                    if (LiveTimeUpdater.this.playTime < 0L) {
                        LiveTimeUpdater.this.playTime = LiveTimeUpdater.this.liveTime;
                    }
                    LiveTimeUpdater.this.startUpdatePlayTimerDelay(0);
                    LiveTimeUpdater.this.timeShiftUpdaterListener.onUpdater(currentTime, shiftStartTime, shiftEndTime);
                }
            }

            @Override
            public void onFail(int code, String msg, String requestId) {
            }
        });
        request.getAsync();
    }

    private long getEndTime(TimeLineContent requestInfo) {
        List<TimeLineInfo> lines = requestInfo.timelines;
        if (lines != null && lines.size() > 0) {
            return lines.get((int)(lines.size() - 1)).end;
        }
        return 0L;
    }

    private long getStartTime(TimeLineContent requestInfo) {
        List<TimeLineInfo> lines = requestInfo.timelines;
        if (lines != null && lines.size() > 0) {
            return lines.get((int)0).start;
        }
        return 0L;
    }

    public void setUpdaterListener(AliLiveShiftPlayer.OnTimeShiftUpdaterListener listener) {
        this.timeShiftUpdaterListener = listener;
    }

    private void startUpdatePlayTimerDelay(int second) {
        this.stopUpdatePlayTimer();
        this.timer.sendEmptyMessageDelayed(WHAT_UPDATE_PLAY_TIME, (long)(second * 1000));
    }

    private void stopUpdatePlayTimer() {
        this.timer.removeMessages(WHAT_UPDATE_PLAY_TIME);
    }

    private void startUpdateLiveTimerDelay(int seconds) {
        this.stopUpdateLiveTimer();
        this.timer.sendEmptyMessageDelayed(WHAT_UPDATE_LIVE_TIME, (long)(seconds * 1000));
    }

    private void stopUpdateLiveTimer() {
        this.timer.removeMessages(WHAT_UPDATE_LIVE_TIME);
    }

    public void startUpdater() {
        this.stopUpdater();
        this.startUpdateLiveTimerDelay(0);
    }

    public void pauseUpdater() {
        this.needPause = true;
    }

    public void resumeUpdater() {
        this.needPause = false;
    }

    public void stopUpdater() {
        this.stopUpdateLiveTimer();
        this.stopUpdatePlayTimer();
    }

    public long getPlayTime() {
        return this.playTime;
    }

    public long getLiveTime() {
        return this.liveTime;
    }
}

