/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.baseAdapter.decoration;

import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.aliyun.svideo.common.baseAdapter.BaseSectionQuickAdapter;
import com.aliyun.svideo.common.baseAdapter.BaseViewHolder;
import com.aliyun.svideo.common.baseAdapter.entity.SectionEntity;
import java.util.ArrayList;
import java.util.List;

public class GridSectionAverageGapItemDecoration
extends RecyclerView.ItemDecoration {
    private float gapHorizontalDp;
    private float gapVerticalDp;
    private float sectionEdgeHPaddingDp;
    private float sectionEdgeVPaddingDp;
    private int gapHSizePx = -1;
    private int gapVSizePx = -1;
    private int sectionEdgeHPaddingPx;
    private int eachItemHPaddingPx;
    private int sectionEdgeVPaddingPx;
    private List<Section> mSectionList = new ArrayList<Section>();
    private BaseSectionQuickAdapter mAdapter;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            GridSectionAverageGapItemDecoration.this.markSections();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            GridSectionAverageGapItemDecoration.this.markSections();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            GridSectionAverageGapItemDecoration.this.markSections();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            GridSectionAverageGapItemDecoration.this.markSections();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            GridSectionAverageGapItemDecoration.this.markSections();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            GridSectionAverageGapItemDecoration.this.markSections();
        }
    };

    public GridSectionAverageGapItemDecoration(float gapHorizontalDp, float gapVerticalDp, float sectionEdgeHPaddingDp, float sectionEdgeVPaddingDp) {
        this.gapHorizontalDp = gapHorizontalDp;
        this.gapVerticalDp = gapVerticalDp;
        this.sectionEdgeHPaddingDp = sectionEdgeHPaddingDp;
        this.sectionEdgeVPaddingDp = sectionEdgeVPaddingDp;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        if (parent.getLayoutManager() instanceof GridLayoutManager && parent.getAdapter() instanceof BaseSectionQuickAdapter) {
            GridLayoutManager layoutManager = (GridLayoutManager)parent.getLayoutManager();
            BaseSectionQuickAdapter adapter = (BaseSectionQuickAdapter)parent.getAdapter();
            if (this.mAdapter != adapter) {
                this.setUpWithAdapter(adapter);
            }
            int spanCount = layoutManager.getSpanCount();
            int position = parent.getChildAdapterPosition(view);
            SectionEntity entity = (SectionEntity)adapter.getItem(position);
            if (entity != null && entity.isHeader) {
                outRect.set(0, 0, 0, 0);
                return;
            }
            Section section = this.findSectionLastItemPos(position);
            if (this.gapHSizePx < 0 || this.gapVSizePx < 0) {
                this.transformGapDefinition(parent, spanCount);
            }
            outRect.top = this.gapVSizePx;
            outRect.bottom = 0;
            int visualPos = position + 1 - section.startPos;
            if (visualPos % spanCount == 1) {
                outRect.left = this.sectionEdgeHPaddingPx;
                outRect.right = this.eachItemHPaddingPx - this.sectionEdgeHPaddingPx;
            } else if (visualPos % spanCount == 0) {
                outRect.left = this.eachItemHPaddingPx - this.sectionEdgeHPaddingPx;
                outRect.right = this.sectionEdgeHPaddingPx;
            } else {
                outRect.left = this.gapHSizePx - (this.eachItemHPaddingPx - this.sectionEdgeHPaddingPx);
                outRect.right = this.eachItemHPaddingPx - outRect.left;
            }
            if (visualPos - spanCount <= 0) {
                outRect.top = this.sectionEdgeVPaddingPx;
            }
            if (this.isLastRow(visualPos, spanCount, section.getCount())) {
                outRect.bottom = this.sectionEdgeVPaddingPx;
            }
        } else {
            super.getItemOffsets(outRect, view, parent, state);
        }
    }

    private void setUpWithAdapter(BaseSectionQuickAdapter<SectionEntity, BaseViewHolder> adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        this.mAdapter.registerAdapterDataObserver(this.mDataObserver);
        this.markSections();
    }

    private void markSections() {
        if (this.mAdapter != null) {
            BaseSectionQuickAdapter adapter = this.mAdapter;
            this.mSectionList.clear();
            SectionEntity sectionEntity = null;
            Section section = new Section();
            int size = adapter.getItemCount();
            for (int i = 0; i < size; ++i) {
                sectionEntity = (SectionEntity)adapter.getItem(i);
                if (sectionEntity != null && sectionEntity.isHeader) {
                    if (section != null && i != 0) {
                        section.endPos = i - 1;
                        this.mSectionList.add(section);
                    }
                    section = new Section();
                    section.startPos = i + 1;
                    continue;
                }
                section.endPos = i;
            }
            if (!this.mSectionList.contains(section)) {
                this.mSectionList.add(section);
            }
        }
    }

    private void transformGapDefinition(RecyclerView parent, int spanCount) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            parent.getDisplay().getMetrics(displayMetrics);
        }
        this.gapHSizePx = (int)TypedValue.applyDimension((int)1, (float)this.gapHorizontalDp, (DisplayMetrics)displayMetrics);
        this.gapVSizePx = (int)TypedValue.applyDimension((int)1, (float)this.gapVerticalDp, (DisplayMetrics)displayMetrics);
        this.sectionEdgeHPaddingPx = (int)TypedValue.applyDimension((int)1, (float)this.sectionEdgeHPaddingDp, (DisplayMetrics)displayMetrics);
        this.sectionEdgeVPaddingPx = (int)TypedValue.applyDimension((int)1, (float)this.sectionEdgeVPaddingDp, (DisplayMetrics)displayMetrics);
        this.eachItemHPaddingPx = (this.sectionEdgeHPaddingPx * 2 + this.gapHSizePx * (spanCount - 1)) / spanCount;
    }

    private Section findSectionLastItemPos(int curPos) {
        for (Section section : this.mSectionList) {
            if (!section.contains(curPos)) continue;
            return section;
        }
        return null;
    }

    private boolean isLastRow(int visualPos, int spanCount, int sectionItemCount) {
        int lastRowCount = sectionItemCount % spanCount;
        lastRowCount = lastRowCount == 0 ? spanCount : lastRowCount;
        return visualPos > sectionItemCount - lastRowCount;
    }

    private class Section {
        public int startPos = 0;
        public int endPos = 0;

        private Section() {
        }

        public int getCount() {
            return this.endPos - this.startPos + 1;
        }

        public boolean contains(int pos) {
            return pos >= this.startPos && pos <= this.endPos;
        }

        public String toString() {
            return "Section{startPos=" + this.startPos + ", endPos=" + this.endPos + '}';
        }
    }
}

