/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.provider.MediaStore;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtils {
    public static File getDbDir(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return context.getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS);
        }
        File file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/AliPlayerDemoDownload/");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static long getSdcardAvailableSize() {
        File directory = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(directory.getPath());
        long blockAvailable = statFs.getAvailableBlocks();
        long blockSize = statFs.getBlockSize();
        return blockAvailable * blockSize;
    }

    public static long getSdcardTotalSize() {
        File directory = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(directory.getPath());
        long blockCount = statFs.getBlockCount();
        long blockSize = statFs.getBlockSize();
        return blockCount * blockSize;
    }

    public static File getApplicationSdcardPath(Context context) {
        File var1 = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        if (var1 == null) {
            var1 = context.getFilesDir();
        }
        return var1;
    }

    public static boolean deleteFD(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File var1 = new File(path);
        File var2 = new File(var1.getAbsolutePath() + System.currentTimeMillis());
        var1.renameTo(var2);
        return FileUtils.deleteFD(var2);
    }

    public static boolean deleteFD(File fd) {
        if (!fd.exists()) {
            return false;
        }
        return fd.isDirectory() ? FileUtils.deleteDirectory(fd) : fd.delete();
    }

    public static boolean deleteDirectory(File dir) {
        FileUtils.clearDirectory(dir);
        return dir.delete();
    }

    public static void clearDirectory(File dir) {
        File[] var1 = dir.listFiles();
        if (var1 != null) {
            File[] var2 = var1;
            int var3 = var1.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                File var5 = var2[var4];
                if (var5.isDirectory()) {
                    FileUtils.deleteDirectory(var5);
                    continue;
                }
                var5.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBitmap(Bitmap bitmap, String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File f = new File(path, "snapShot_" + System.currentTimeMillis() + ".png");
        FileOutputStream out = null;
        if (f.exists()) {
            f.delete();
        }
        try {
            out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return f.getAbsolutePath();
    }

    public static String getDir(Context context) {
        String dir = Build.VERSION.SDK_INT >= 29 ? context.getExternalFilesDir("") + File.separator + "Media" + File.separator : Environment.getExternalStorageDirectory() + File.separator + "DCIM" + File.separator + "Camera" + File.separator;
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dir;
    }

    @RequiresApi(api=29)
    public static void saveImgToMediaStore(Context context, String fileName, String mimeType) {
        ContentValues values = new ContentValues();
        values.put("_display_name", fileName);
        values.put("mime_type", mimeType);
        values.put("is_pending", Integer.valueOf(1));
        ContentResolver resolver = context.getContentResolver();
        Uri collection = MediaStore.Images.Media.getContentUri((String)"external_primary");
        Uri item = resolver.insert(collection, values);
        try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(item, "w", null);){
            int len;
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(fileName));
            ParcelFileDescriptor.AutoCloseOutputStream outputStream = new ParcelFileDescriptor.AutoCloseOutputStream(pfd);
            BufferedOutputStream bot = new BufferedOutputStream((OutputStream)outputStream);
            byte[] bt = new byte[2048];
            while ((len = bin.read(bt)) >= 0) {
                bot.write(bt, 0, len);
                bot.flush();
            }
            bin.close();
            bot.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        values.clear();
        values.put("is_pending", Integer.valueOf(0));
        resolver.update(item, values, null, null);
    }

    @RequiresApi(api=29)
    public static void saveVideoToMediaStore(Context context, String fileName) {
        long startTime = System.currentTimeMillis();
        ContentValues values = new ContentValues();
        String name = startTime + "-video.mp4";
        values.put("_display_name", name);
        values.put("mime_type", "video/mp4");
        values.put("is_pending", Integer.valueOf(1));
        ContentResolver resolver = context.getContentResolver();
        Uri collection = MediaStore.Video.Media.getContentUri((String)"external_primary");
        Uri item = resolver.insert(collection, values);
        try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(item, "w", null);){
            int len;
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(fileName));
            ParcelFileDescriptor.AutoCloseOutputStream outputStream = new ParcelFileDescriptor.AutoCloseOutputStream(pfd);
            BufferedOutputStream bot = new BufferedOutputStream((OutputStream)outputStream);
            byte[] bt = new byte[2048];
            while ((len = bin.read(bt)) >= 0) {
                bot.write(bt, 0, len);
                bot.flush();
            }
            bin.close();
            bot.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        values.clear();
        values.put("is_pending", Integer.valueOf(0));
        resolver.update(item, values, null, null);
    }
}

