/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.text.TextUtils;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class DownloadSaveInfoUtil {
    private String mSaveDir;

    public DownloadSaveInfoUtil(String saveDir) {
        this.mSaveDir = saveDir;
    }

    public void writeDownloadingInfo(AliyunDownloadMediaInfo downloadInfo) {
        String savePath = downloadInfo.getSavePath();
        if (!TextUtils.isEmpty((CharSequence)savePath)) {
            File saveFile = new File(downloadInfo.getSavePath());
            File infoFile = new File(this.mSaveDir, DownloadSaveInfoUtil.getInfoFileName(saveFile.getName()));
            if (!infoFile.exists() || infoFile.isDirectory()) {
                try {
                    infoFile.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ArrayList<AliyunDownloadMediaInfo> infos = new ArrayList<AliyunDownloadMediaInfo>();
            infos.add(downloadInfo);
            if (infoFile.exists()) {
                String content = AliyunDownloadMediaInfo.getJsonFromInfos(infos);
                this.writeStringToFile(infoFile, content);
            }
        }
    }

    private static String getInfoFileName(String saveName) {
        return "." + saveName + ".info";
    }

    public List<AliyunDownloadMediaInfo> getAlivcDownloadeds() {
        if (this.mSaveDir != null) {
            File infoFile = new File(this.mSaveDir);
            if (infoFile.exists() && infoFile.isDirectory()) {
                File[] childs = infoFile.listFiles();
                if (childs == null) {
                    return null;
                }
                ArrayList<AliyunDownloadMediaInfo> infos = new ArrayList<AliyunDownloadMediaInfo>();
                File[] var4 = childs;
                int var5 = childs.length;
                for (int var6 = 0; var6 < var5; ++var6) {
                    String infoContent;
                    List<AliyunDownloadMediaInfo> infosFromJson;
                    File child = var4[var6];
                    if (!child.getAbsolutePath().endsWith(".info") || (infosFromJson = AliyunDownloadMediaInfo.getInfosFromJson(infoContent = this.readStringFromFile(child))) == null || infosFromJson.isEmpty()) continue;
                    for (AliyunDownloadMediaInfo info : infosFromJson) {
                        if (info.getStatus() == AliyunDownloadMediaInfo.Status.Complete) {
                            info.setStatus(AliyunDownloadMediaInfo.Status.Complete);
                        }
                        infos.add(info);
                    }
                }
                return infos;
            }
            return null;
        }
        return null;
    }

    public void fillDownloadInfoFromCache(AliyunDownloadMediaInfo info) {
        File file;
        String saveInfoName;
        File infoFile;
        String infoContent;
        List<AliyunDownloadMediaInfo> infosFromJson;
        String savePath = info.getSavePath();
        if (!TextUtils.isEmpty((CharSequence)savePath) && (infosFromJson = AliyunDownloadMediaInfo.getInfosFromJson(infoContent = this.readStringFromFile(infoFile = new File(this.mSaveDir, saveInfoName = DownloadSaveInfoUtil.getInfoFileName((file = new File(savePath)).getName()))))) != null && !infosFromJson.isEmpty()) {
            for (AliyunDownloadMediaInfo cacheInfo : infosFromJson) {
                info.setDownloadIndex(cacheInfo.getDownloadIndex());
                info.setProgress(cacheInfo.getProgress());
                AliyunDownloadMediaInfo.Status cacheInfoStatus = cacheInfo.getStatus();
                if (cacheInfoStatus == AliyunDownloadMediaInfo.Status.Complete) {
                    info.setStatus(cacheInfoStatus);
                }
                info.setSavePath(cacheInfo.getSavePath());
                info.setSize(Math.max(info.getSize(), cacheInfo.getSize()));
            }
        }
    }

    public void deleteInfo(AliyunDownloadMediaInfo info) {
        DownloadSaveInfoUtil.deleteInfo(info, this.mSaveDir);
    }

    public void deleteAllInfo(ArrayList<AliyunDownloadMediaInfo> infos) {
        for (AliyunDownloadMediaInfo info : infos) {
            DownloadSaveInfoUtil.deleteInfo(info, this.mSaveDir);
        }
    }

    public static void deleteInfo(AliyunDownloadMediaInfo info, String saveDir) {
        File file;
        String saveInfoName;
        File infoFile;
        String savePath;
        if (info != null && !TextUtils.isEmpty((CharSequence)(savePath = info.getSavePath())) && (infoFile = new File(saveDir, saveInfoName = DownloadSaveInfoUtil.getInfoFileName((file = new File(savePath)).getName()))).exists() && !infoFile.isDirectory()) {
            infoFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStringToFile(File file, String content) {
        try (PrintStream ps = null;){
            ps = new PrintStream(new FileOutputStream(file));
            ps.println(content);
            ps.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFromFile(File file) {
        BufferedReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                stringBuilder.append(tempString);
            }
            reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }
}

