/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.aliyun.player.alivcplayerexpand.util.database.DatabaseHelper;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import java.util.ArrayList;
import java.util.List;

public class DatabaseManager {
    public static final String DB_NAME = "Player_Download.db";
    public static final String HISTORY_DB_NAME = "Player_Watch_History.db";
    private static final String TABLE_NAME = "player_download_info";
    public static final String WATCH_HISTORY_TABLE_NAME = "player_watch_history_info";
    private static final int PREPARED_STATE = 1;
    private static final int DOWNLOADING_STATE = 3;
    private static final int STOP_STATE = 4;
    private static final int COMPLETED_STATE = 5;
    private static final int WAIT_STATE = 2;
    private static final int NOT_WATCH = 0;
    private static final int HAS_WATCHED = 1;
    public static final String CREATE_TABLE_SQL = "create table if not exists player_download_info (id integer primary key autoincrement,vid text,quality text,title text,coverurl text,duration text,size text,progress integer,status integer,path text,trackindex integer,tvid text,tvname text,watched integer,tvcoverurl text,vidtype integer,format text)";
    public static final String CREATE_TABLE_SQL_WATCH_HISTORY = "create table if not exists player_watch_history_info (id integer primary key autoincrement,vid text,title text,coverurl text,duration text,size text,watchduration integer,tvid text,description text,status text,firstframeurl text,tags text,tvname text,dot text,sort text,isvip text,downloading text,updatetime text,downloaded text,watchpercent integer)";
    private static final String SELECT_ALL_SQL = "select * from player_download_info";
    private static final String SELECT_ALL_BY_TVID = "select * from player_download_info where tvid=?";
    private static final String SELECT_WITH_STATUS_SQL = "select * from player_download_info where status=?";
    private static final String SELECT_WATCHED_SQL = "select * from player_download_info where watched=?";
    public static final String ID = "id";
    public static final String VID = "vid";
    public static final String QUALITY = "quality";
    public static final String TITLE = "title";
    public static final String COVERURL = "coverurl";
    public static final String DURATION = "duration";
    public static final String SIZE = "size";
    public static final String PROGRESS = "progress";
    public static final String STATUS = "status";
    public static final String PATH = "path";
    public static final String FORMAT = "format";
    public static final String TRACKINDEX = "trackindex";
    public static final String TVID = "tvid";
    public static final String TVCOVERURL = "tvcoverurl";
    public static final String WATCHED = "watched";
    public static final String VIDTYPE = "vidtype";
    public static final String WATCHDURATION = "watchduration";
    public static final String DESCRIPTION = "description";
    public static final String FIRSTFRAMEURL = "firstframeurl";
    public static final String TAGS = "tags";
    public static final String TVNAME = "tvname";
    public static final String DOT = "dot";
    public static final String SORT = "sort";
    public static final String ISVIP = "isvip";
    public static final String DOWNLOADING = "downloading";
    public static final String DOWNLOADED = "downloaded";
    public static final String WATCHPERCENT = "watchpercent";
    public static final String UPDATETIME = "updatetime";
    private static DatabaseManager mInstance = null;
    private DatabaseHelper databaseHelper;
    private SQLiteDatabase mSqliteDatabase;

    private DatabaseManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DatabaseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDataBase(Context context) {
        this.databaseHelper = DatabaseHelper.getInstance(context.getApplicationContext());
        if (this.mSqliteDatabase != null) return;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (this.mSqliteDatabase != null) return;
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDataBase(Context context, String dbPath) {
        this.databaseHelper = DatabaseHelper.getInstance(context, dbPath);
        if (this.mSqliteDatabase != null) return;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (this.mSqliteDatabase != null) return;
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int selectItemExist(AliyunDownloadMediaInfo mediaInfo) {
        Cursor cursor = this.mSqliteDatabase.query(TABLE_NAME, new String[]{ID}, "vid=? and quality=?", new String[]{mediaInfo.getVid(), mediaInfo.getQuality()}, null, null, null);
        int count = cursor.getCount();
        cursor.close();
        return count;
    }

    public long insert(AliyunDownloadMediaInfo mediaInfo) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(VID, mediaInfo.getVid());
        contentValues.put(QUALITY, mediaInfo.getQuality());
        contentValues.put(TITLE, mediaInfo.getTitle());
        contentValues.put(FORMAT, mediaInfo.getFormat());
        contentValues.put(COVERURL, mediaInfo.getCoverUrl());
        contentValues.put(DURATION, Long.valueOf(mediaInfo.getDuration()));
        contentValues.put(SIZE, Long.valueOf(mediaInfo.getSize()));
        contentValues.put(PROGRESS, Integer.valueOf(mediaInfo.getProgress()));
        contentValues.put(STATUS, Integer.valueOf(mediaInfo.getStatus().ordinal()));
        contentValues.put(PATH, mediaInfo.getSavePath());
        contentValues.put(TRACKINDEX, Integer.valueOf(mediaInfo.getQualityIndex()));
        contentValues.put(TVID, mediaInfo.getTvId());
        contentValues.put(TVNAME, mediaInfo.getTvName());
        contentValues.put(TVCOVERURL, mediaInfo.getTvCoverUrl());
        contentValues.put(WATCHED, Integer.valueOf(mediaInfo.getWatched()));
        contentValues.put(VIDTYPE, Integer.valueOf(mediaInfo.getVidType()));
        return this.mSqliteDatabase.insert(TABLE_NAME, null, contentValues);
    }

    public int delete(AliyunDownloadMediaInfo mediaInfo) {
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        return this.mSqliteDatabase.delete(TABLE_NAME, "vid=? and quality=?", new String[]{mediaInfo.getVid(), mediaInfo.getQuality()});
    }

    public int update(AliyunDownloadMediaInfo mediaInfo) {
        if (TextUtils.isEmpty((CharSequence)mediaInfo.getTvId())) {
            return this.updateByVidAndQuality(mediaInfo);
        }
        return this.updateByVid(mediaInfo);
    }

    private int updateByVidAndQuality(AliyunDownloadMediaInfo mediaInfo) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(PROGRESS, Integer.valueOf(mediaInfo.getProgress()));
        contentValues.put(STATUS, Integer.valueOf(mediaInfo.getStatus().ordinal()));
        contentValues.put(PATH, mediaInfo.getSavePath());
        contentValues.put(TRACKINDEX, Integer.valueOf(mediaInfo.getQualityIndex()));
        contentValues.put(FORMAT, mediaInfo.getFormat());
        contentValues.put(TVNAME, mediaInfo.getTvName());
        contentValues.put(WATCHED, Integer.valueOf(mediaInfo.getWatched()));
        return this.mSqliteDatabase.update(TABLE_NAME, contentValues, " vid=? and quality=?", new String[]{mediaInfo.getVid(), mediaInfo.getQuality()});
    }

    private int updateByVid(AliyunDownloadMediaInfo mediaInfo) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(PROGRESS, Integer.valueOf(mediaInfo.getProgress()));
        contentValues.put(STATUS, Integer.valueOf(mediaInfo.getStatus().ordinal()));
        contentValues.put(PATH, mediaInfo.getSavePath());
        contentValues.put(TRACKINDEX, Integer.valueOf(mediaInfo.getQualityIndex()));
        contentValues.put(FORMAT, mediaInfo.getFormat());
        contentValues.put(QUALITY, mediaInfo.getQuality());
        contentValues.put(TVNAME, mediaInfo.getTvName());
        contentValues.put(WATCHED, Integer.valueOf(mediaInfo.getWatched()));
        return this.mSqliteDatabase.update(TABLE_NAME, contentValues, " vid=?", new String[]{mediaInfo.getVid()});
    }

    public void deleteAll() {
        if (!this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        this.mSqliteDatabase.delete(TABLE_NAME, "", new String[0]);
    }

    public void deleteItem(AliyunDownloadMediaInfo mediaInfo) {
        if (!this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        this.mSqliteDatabase.delete(TABLE_NAME, "vid=?,quality=?", new String[]{mediaInfo.getVid(), mediaInfo.getQuality()});
    }

    public List<AliyunDownloadMediaInfo> selectWatchedList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WATCHED_SQL, new String[]{"1"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectDownloadingList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WITH_STATUS_SQL, new String[]{"3"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectStopedList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WITH_STATUS_SQL, new String[]{"4"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectWaitList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WITH_STATUS_SQL, new String[]{"2"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectCompletedList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WITH_STATUS_SQL, new String[]{"5"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectPreparedList() {
        List<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WITH_STATUS_SQL, new String[]{"1"});
        queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectAllByTvId(String tvId) {
        if (!this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_ALL_BY_TVID, new String[]{tvId});
        List<AliyunDownloadMediaInfo> queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    public List<AliyunDownloadMediaInfo> selectAll() {
        if (!this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_ALL_SQL, new String[0]);
        List<AliyunDownloadMediaInfo> queryLists = this.selectAllCursorToDownloadMediaInfo(cursor);
        cursor.close();
        return queryLists;
    }

    private List<AliyunDownloadMediaInfo> selectAllCursorToDownloadMediaInfo(Cursor cursor) {
        ArrayList<AliyunDownloadMediaInfo> queryLists = new ArrayList<AliyunDownloadMediaInfo>();
        if (cursor == null || cursor.getCount() <= 0) {
            if (cursor != null) {
                cursor.close();
            }
            return queryLists;
        }
        while (cursor.moveToNext()) {
            AliyunDownloadMediaInfo mediaInfo = new AliyunDownloadMediaInfo();
            mediaInfo.setVid(cursor.getString(cursor.getColumnIndex(VID)));
            mediaInfo.setQuality(cursor.getString(cursor.getColumnIndex(QUALITY)));
            mediaInfo.setTitle(cursor.getString(cursor.getColumnIndex(TITLE)));
            mediaInfo.setCoverUrl(cursor.getString(cursor.getColumnIndex(COVERURL)));
            String duration = cursor.getString(cursor.getColumnIndex(DURATION));
            mediaInfo.setDuration(Long.valueOf(duration));
            String size = cursor.getString(cursor.getColumnIndex(SIZE));
            mediaInfo.setSize(Long.valueOf(size));
            mediaInfo.setProgress(cursor.getInt(cursor.getColumnIndex(PROGRESS)));
            mediaInfo.setSavePath(cursor.getString(cursor.getColumnIndex(PATH)));
            int status = cursor.getInt(cursor.getColumnIndex(STATUS));
            mediaInfo.setFormat(cursor.getString(cursor.getColumnIndex(FORMAT)));
            mediaInfo.setQualityIndex(cursor.getInt(cursor.getColumnIndex(TRACKINDEX)));
            mediaInfo.setTvId(cursor.getString(cursor.getColumnIndex(TVID)));
            mediaInfo.setTvName(cursor.getString(cursor.getColumnIndex(TVNAME)));
            mediaInfo.setTvCoverUrl(cursor.getString(cursor.getColumnIndex(TVCOVERURL)));
            mediaInfo.setWatched(cursor.getInt(cursor.getColumnIndex(WATCHED)));
            mediaInfo.setVidType(cursor.getInt(cursor.getColumnIndex(VIDTYPE)));
            switch (status) {
                case 0: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Idle);
                    break;
                }
                case 1: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
                    break;
                }
                case 2: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Wait);
                    break;
                }
                case 3: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Start);
                    break;
                }
                case 4: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
                    break;
                }
                case 5: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Complete);
                    break;
                }
                case 6: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Error);
                    break;
                }
                default: {
                    mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Idle);
                }
            }
            queryLists.add(mediaInfo);
        }
        return queryLists;
    }

    public void close() {
        if (this.mSqliteDatabase != null) {
            this.mSqliteDatabase.close();
        }
        if (this.databaseHelper != null) {
            this.databaseHelper.close();
        }
    }
}

