/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.aliyun.player.alivcplayerexpand.bean.DotBean;
import com.aliyun.player.alivcplayerexpand.bean.LongVideoBean;
import com.aliyun.player.alivcplayerexpand.util.database.DatabaseHistoryHelper;
import com.aliyun.player.alivcplayerexpand.util.database.DatabaseManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class LongVideoDatabaseManager {
    private static final String SELECT_ALL_WATCH_HISTORY = "select * from player_watch_history_info";
    private static final String SELECT_ALL_WATCH_HISTORY_LIMIT = "select * from player_watch_history_info order by updatetime desc limit 20";
    private static final String SELECT_WATCH_HISTORY_WITH_VID = "select * from player_watch_history_info where vid = ? ";
    private static LongVideoDatabaseManager mInstance = null;
    private DatabaseHistoryHelper databaseHelper;
    private SQLiteDatabase mSqliteDatabase;
    private Gson mGson = new Gson();

    private LongVideoDatabaseManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LongVideoDatabaseManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new LongVideoDatabaseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDataBase(Context context) {
        this.databaseHelper = DatabaseHistoryHelper.getInstance(context);
        if (this.mSqliteDatabase != null) return;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (this.mSqliteDatabase != null) return;
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void close() {
        if (this.mSqliteDatabase != null) {
            this.mSqliteDatabase.close();
        }
        if (this.databaseHelper != null) {
            this.databaseHelper.close();
        }
    }

    private ContentValues longVideoBeanToContentValues(LongVideoBean longVideoBean) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", longVideoBean.getTitle());
        contentValues.put("vid", longVideoBean.getVideoId());
        contentValues.put("description", longVideoBean.getDescription());
        contentValues.put("duration", longVideoBean.getDuration());
        contentValues.put("coverurl", longVideoBean.getCoverUrl());
        contentValues.put("status", longVideoBean.getStatus());
        contentValues.put("firstframeurl", longVideoBean.getFirstFrameUrl());
        contentValues.put("size", longVideoBean.getSize());
        contentValues.put("tags", longVideoBean.getTags());
        contentValues.put("tvid", longVideoBean.getTvId());
        contentValues.put("tvname", longVideoBean.getTvName());
        List<DotBean> dotList = longVideoBean.getDot();
        contentValues.put("dot", this.mGson.toJson(dotList));
        contentValues.put("sort", longVideoBean.getSort());
        contentValues.put("isvip", Boolean.valueOf(longVideoBean.getIsVip()));
        contentValues.put("downloading", Boolean.valueOf(longVideoBean.isDownloading()));
        contentValues.put("downloaded", Boolean.valueOf(longVideoBean.isDownloaded()));
        contentValues.put("watchpercent", Integer.valueOf(longVideoBean.getWatchPercent()));
        contentValues.put("watchduration", longVideoBean.getWatchDuration());
        contentValues.put("updatetime", Long.valueOf(System.currentTimeMillis()));
        return contentValues;
    }

    public void updateWatchHistory(LongVideoBean longVideoBean) {
        List<LongVideoBean> longVideoBeans = this.selectWatchHistoryByVid(longVideoBean);
        ContentValues contentValues = this.longVideoBeanToContentValues(longVideoBean);
        if (longVideoBeans == null || longVideoBeans.size() <= 0) {
            this.insertWatchHistory(longVideoBean);
        } else {
            this.mSqliteDatabase.update("player_watch_history_info", contentValues, "vid = ?", new String[]{longVideoBean.getVideoId()});
        }
    }

    private void insertWatchHistory(LongVideoBean longVideoBean) {
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        ContentValues contentValues = this.longVideoBeanToContentValues(longVideoBean);
        this.mSqliteDatabase.insert("player_watch_history_info", null, contentValues);
    }

    public List<LongVideoBean> selectAllWatchHistory() {
        List<LongVideoBean> queryLists = new ArrayList<LongVideoBean>();
        if (this.databaseHelper == null) {
            return queryLists;
        }
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_ALL_WATCH_HISTORY_LIMIT, new String[0]);
        queryLists = this.selectAllWatchHitoryCusrorToLongVideoBean(cursor);
        cursor.close();
        return queryLists;
    }

    public List<LongVideoBean> selectWatchHistoryByVid(LongVideoBean longVideoBean) {
        List<LongVideoBean> longVideoBeans = new ArrayList<LongVideoBean>();
        if (this.mSqliteDatabase == null || !this.mSqliteDatabase.isOpen()) {
            this.mSqliteDatabase = this.databaseHelper.getWritableDatabase();
        }
        if (longVideoBean != null && longVideoBean.getVideoId() != null) {
            Cursor cursor = this.mSqliteDatabase.rawQuery(SELECT_WATCH_HISTORY_WITH_VID, new String[]{longVideoBean.getVideoId()});
            longVideoBeans = this.selectAllWatchHitoryCusrorToLongVideoBean(cursor);
            cursor.close();
        }
        return longVideoBeans;
    }

    private List<LongVideoBean> selectAllWatchHitoryCusrorToLongVideoBean(Cursor cursor) {
        ArrayList<LongVideoBean> queryLists = new ArrayList<LongVideoBean>();
        if (cursor == null || cursor.getCount() <= 0) {
            if (cursor != null) {
                cursor.close();
            }
            return queryLists;
        }
        while (cursor.moveToNext()) {
            LongVideoBean longVideoBean = new LongVideoBean();
            longVideoBean.setTitle(cursor.getString(cursor.getColumnIndex("title")));
            longVideoBean.setVideoId(cursor.getString(cursor.getColumnIndex("vid")));
            longVideoBean.setDescription(cursor.getString(cursor.getColumnIndex("description")));
            longVideoBean.setCoverUrl(cursor.getString(cursor.getColumnIndex("coverurl")));
            String duration = cursor.getString(cursor.getColumnIndex("duration"));
            longVideoBean.setDuration(duration);
            String size = cursor.getString(cursor.getColumnIndex("size"));
            longVideoBean.setSize(size);
            longVideoBean.setTvId(cursor.getString(cursor.getColumnIndex("tvid")));
            longVideoBean.setFirstFrameUrl(cursor.getString(cursor.getColumnIndex("firstframeurl")));
            longVideoBean.setTags(cursor.getString(cursor.getColumnIndex("tags")));
            longVideoBean.setTvName(cursor.getString(cursor.getColumnIndex("tvname")));
            String jsonDotList = cursor.getString(cursor.getColumnIndex("dot"));
            List dotBeans = (List)this.mGson.fromJson(jsonDotList, new TypeToken<List<DotBean>>(){}.getType());
            longVideoBean.setDot(dotBeans);
            longVideoBean.setSort(cursor.getString(cursor.getColumnIndex("sort")));
            String isVip = cursor.getString(cursor.getColumnIndex("isvip"));
            boolean videoIsVip = TextUtils.isEmpty((CharSequence)isVip) ? false : !"0".equals(isVip);
            longVideoBean.setIsVip(videoIsVip);
            String isDownloading = cursor.getString(cursor.getColumnIndex("downloading"));
            longVideoBean.setDownloading(Boolean.parseBoolean(isDownloading));
            String isDownloaded = cursor.getString(cursor.getColumnIndex("downloaded"));
            longVideoBean.setDownloading(Boolean.parseBoolean(isDownloaded));
            longVideoBean.setWatchDuration(cursor.getString(cursor.getColumnIndex("watchduration")));
            longVideoBean.setWatchPercent(cursor.getInt(cursor.getColumnIndex("watchpercent")));
            queryLists.add(longVideoBean);
        }
        return queryLists;
    }
}

