CUR_DIR=$(pwd)

# create ARM_SIMULATOR_NO_BITCODE
rm -rf ARM_SIMULATOR_NO_BITCODE
mkdir -p ARM_SIMULATOR_NO_BITCODE
cp -rf ARM_SIMULATOR/*.framework ARM_SIMULATOR_NO_BITCODE/

cd ARM_SIMULATOR_NO_BITCODE/
frameworkList=$(ls)
for framework in ${frameworkList}
do
    name=${framework%.*}
    echo "strip bitcode for $name"
    xcrun bitcode_strip ${name}.framework/${name} -r -o ${name}.framework/${name}
done
cd ..

# create ARM
rm -rf ARM
mkdir -p ARM
cp -rf ARM_SIMULATOR/*.framework ARM/

cd ARM/
frameworkList=$(ls)
for framework in ${frameworkList}
do
    name=${framework%.*}
    echo "remove i386/x86_64 for $name"
    lipo -remove i386 ${name}.framework/${name} -o ${name}.framework/${name}
    lipo -remove x86_64 ${name}.framework/${name} -o ${name}.framework/${name}
done
cd ..

# create ARM_NO_BITCODE
rm -rf ARM_NO_BITCODE
mkdir -p ARM_NO_BITCODE
cp -rf ARM/*.framework ARM_NO_BITCODE/

cd ARM_NO_BITCODE/
frameworkList=$(ls)
for framework in ${frameworkList}
do
    name=${framework%.*}
    echo "strip bitcode for ARM $name"
    xcrun bitcode_strip ${name}.framework/${name} -r -o ${name}.framework/${name}
done
cd ..
