/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunlistplayer.adapter;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.aliyun.player.aliyunlistplayer.listener.OnViewPagerListener;

public class PagerLayoutManager
extends LinearLayoutManager
implements View.OnTouchListener {
    private PagerSnapHelper mPagerSnapHelper;
    private OnViewPagerListener mOnViewPagerListener;
    private int mState;
    private int mdy;
    private int direction;
    private RecyclerView.OnChildAttachStateChangeListener mChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (PagerLayoutManager.this.mOnViewPagerListener != null && PagerLayoutManager.this.getChildCount() == 1) {
                PagerLayoutManager.this.mOnViewPagerListener.onInitComplete();
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
            if (PagerLayoutManager.this.direction >= 0) {
                if (PagerLayoutManager.this.mOnViewPagerListener != null) {
                    PagerLayoutManager.this.mOnViewPagerListener.onPageRelease(true, PagerLayoutManager.this.getPosition(view), view);
                }
            } else if (PagerLayoutManager.this.mOnViewPagerListener != null) {
                PagerLayoutManager.this.mOnViewPagerListener.onPageRelease(false, PagerLayoutManager.this.getPosition(view), view);
            }
        }
    };

    public PagerLayoutManager(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mPagerSnapHelper = new PagerSnapHelper();
    }

    public void onAttachedToWindow(RecyclerView recyclerView) {
        super.onAttachedToWindow(recyclerView);
        if (recyclerView.getOnFlingListener() == null) {
            this.mPagerSnapHelper.attachToRecyclerView(recyclerView);
        }
        recyclerView.addOnChildAttachStateChangeListener(this.mChildAttachStateChangeListener);
        recyclerView.setOnTouchListener((View.OnTouchListener)this);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                PagerLayoutManager.this.mState = newState;
                switch (PagerLayoutManager.this.mState) {
                    case 0: {
                        View viewIdle = PagerLayoutManager.this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)PagerLayoutManager.this);
                        if (viewIdle == null) {
                            return;
                        }
                        int positionIdle = PagerLayoutManager.this.getPosition(viewIdle);
                        if (PagerLayoutManager.this.mOnViewPagerListener == null || PagerLayoutManager.this.getChildCount() != 1) break;
                        PagerLayoutManager.this.mOnViewPagerListener.onPageSelected(positionIdle, positionIdle == PagerLayoutManager.this.getItemCount() - 1, viewIdle);
                        break;
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                PagerLayoutManager.this.mdy = dy;
            }
        });
    }

    public boolean viewPagerListenerIsNull() {
        return this.mOnViewPagerListener == null;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.direction = dy;
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.direction = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    public void setOnViewPagerListener(OnViewPagerListener listener) {
        this.mOnViewPagerListener = listener;
    }

    public void clearOnViewPagerListener() {
        this.mOnViewPagerListener = null;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int position;
                View snapView;
                if (this.mPagerSnapHelper == null || (snapView = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this)) == null || (position = this.getPosition(snapView)) != 0 || this.mdy >= 0 || this.mOnViewPagerListener == null || this.getChildCount() != 1) break;
                this.mOnViewPagerListener.onPageSelected(position, false, snapView);
                break;
            }
        }
        return false;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        try {
            super.onLayoutChildren(recycler, state);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

