/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.widget.Toast;
import java.lang.reflect.Field;

public class FixedToastUtils {
    private static Field mFieldTN;
    private static Field mFieldTNHandler;
    private static Toast mToast;

    public static Toast show(Context context, String message) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)message, (int)0);
            if (Build.VERSION.SDK_INT == 25) {
                FixedToastUtils.hook(mToast);
            }
        } else {
            mToast.setDuration(0);
            mToast.setText((CharSequence)message);
        }
        mToast.show();
        return mToast;
    }

    public static Toast show(Context context, int resId) {
        return FixedToastUtils.show(context, context.getResources().getString(resId));
    }

    private static void hook(Toast toast) {
        try {
            Object tn = mFieldTN.get(toast);
            Handler preHandler = (Handler)mFieldTNHandler.get(tn);
            mFieldTNHandler.set(tn, (Object)new FiexHandler(preHandler));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Build.VERSION.SDK_INT == 25) {
            try {
                mFieldTN = Toast.class.getDeclaredField("mTN");
                mFieldTN.setAccessible(true);
                mFieldTNHandler = mFieldTN.getType().getDeclaredField("mHandler");
                mFieldTNHandler.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class FiexHandler
    extends Handler {
        private Handler impl;

        FiexHandler(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

