/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.choice;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import java.util.ArrayList;
import java.util.List;

public class AlivcCheckItemDialog
extends Dialog {
    private static final String TAG = AlivcCheckItemDialog.class.getName();
    private static final int ANIMATION_DURATION = 200;
    private View mContentView;
    private boolean mIsAnimating = false;
    OnChoiceItemListener onChoiceItemListener;

    public AlivcCheckItemDialog(@NonNull Context context) {
        super(context, R.style.BottomCheckDialog);
    }

    public AlivcCheckItemDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.height = -2;
        params.gravity = 81;
        int screenWidth = ScreenUtils.getWidth((Context)this.getContext());
        int screenHeight = ScreenUtils.getHeight((Context)this.getContext());
        params.width = screenWidth < screenHeight ? screenWidth : screenHeight;
        this.getWindow().setAttributes(params);
        this.setCanceledOnTouchOutside(true);
    }

    public void setContentView(int layoutResID) {
        this.mContentView = LayoutInflater.from((Context)this.getContext()).inflate(layoutResID, null);
        super.setContentView(layoutResID);
    }

    public void setContentView(@NonNull View view, @Nullable ViewGroup.LayoutParams params) {
        this.mContentView = view;
        super.setContentView(view, params);
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setContentView(View mContentView) {
        this.mContentView = mContentView;
    }

    private void animateUp() {
        if (this.mContentView != null) {
            return;
        }
        TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)translateAnimation);
        animationSet.addAnimation((Animation)alphaAnimation);
        animationSet.setInterpolator((Interpolator)new DecelerateInterpolator());
        animationSet.setDuration(200L);
        animationSet.setFillAfter(true);
        this.mContentView.startAnimation((Animation)animationSet);
    }

    private void animateDown() {
        if (this.mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation((Animation)translate);
        set.addAnimation((Animation)alpha);
        set.setInterpolator((Interpolator)new DecelerateInterpolator());
        set.setDuration(200L);
        set.setFillAfter(true);
        set.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                AlivcCheckItemDialog.this.mIsAnimating = true;
            }

            public void onAnimationEnd(Animation animation) {
                AlivcCheckItemDialog.this.mIsAnimating = false;
                AlivcCheckItemDialog.this.mContentView.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AlivcCheckItemDialog.super.dismiss();
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)("dismiss error\n" + Log.getStackTraceString((Throwable)e)));
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mContentView.startAnimation((Animation)set);
    }

    public void show() {
        super.show();
        this.animateUp();
        if (this.onChoiceItemListener != null) {
            this.onChoiceItemListener.onShow();
        }
    }

    public void dismiss() {
        super.dismiss();
        if (this.mIsAnimating) {
            return;
        }
        this.animateDown();
    }

    public void setOnChoiceItemListener(OnChoiceItemListener onChoiceButtomItemListener) {
        this.onChoiceItemListener = onChoiceButtomItemListener;
    }

    public static class BottomListCheckBuilder {
        private Context mContext;
        private AlivcCheckItemDialog alivcCheckItemDialog;
        private List<BottomCheckListItemData> mItems;
        private RecyclerView recyclerView;
        private int mCheckedIndex;
        private OnCheckItemClickListener onCheckItemClickListener;
        private DialogInterface.OnDismissListener onBottomDialogDismissListener;

        public BottomListCheckBuilder(Context context) {
            this.mContext = context;
            this.mItems = new ArrayList<BottomCheckListItemData>();
        }

        public BottomListCheckBuilder setCheckedIndex(int mCheckedIndex) {
            this.mCheckedIndex = mCheckedIndex;
            return this;
        }

        public BottomListCheckBuilder addItem(String typeAndTag, String value) {
            this.mItems.add(new BottomCheckListItemData(typeAndTag, value, typeAndTag));
            return this;
        }

        public BottomListCheckBuilder setOnCheckItemClickListener(OnCheckItemClickListener onCheckItemClickListener) {
            this.onCheckItemClickListener = onCheckItemClickListener;
            return this;
        }

        public BottomListCheckBuilder setOnBottomDialogDismissListener(DialogInterface.OnDismissListener onBottomDialogDismissListener) {
            this.onBottomDialogDismissListener = onBottomDialogDismissListener;
            return this;
        }

        public AlivcCheckItemDialog build() {
            this.alivcCheckItemDialog = new AlivcCheckItemDialog(this.mContext);
            View contentView = this.buildViews();
            this.alivcCheckItemDialog.setContentView(contentView, new ViewGroup.LayoutParams(-1, -2));
            if (this.onBottomDialogDismissListener != null) {
                this.alivcCheckItemDialog.setOnDismissListener(this.onBottomDialogDismissListener);
            }
            return this.alivcCheckItemDialog;
        }

        private View buildViews() {
            View wrapperView = View.inflate((Context)this.mContext, (int)this.getContentViewLayoutId(), null);
            TextView tvCloseBottomCheck = (TextView)wrapperView.findViewById(R.id.tv_close_bottom_check);
            RecyclerView mContainerView = (RecyclerView)wrapperView.findViewById(R.id.check_list_view);
            tvCloseBottomCheck.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (alivcCheckItemDialog != null) {
                        alivcCheckItemDialog.dismiss();
                    }
                }
            });
            mContainerView.getLayoutParams().height = this.getListMaxHeight();
            this.alivcCheckItemDialog.setOnChoiceItemListener(new OnChoiceItemListener(){

                @Override
                public void onShow() {
                }
            });
            mContainerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
            CheckListAdapter mAdapter = new CheckListAdapter();
            mContainerView.setAdapter((RecyclerView.Adapter)mAdapter);
            return wrapperView;
        }

        protected int getListMaxHeight() {
            return (int)((double)ScreenUtils.getHeight((Context)this.mContext) * 0.5);
        }

        protected int getContentViewLayoutId() {
            return R.layout.alivc_check_list_view_layout;
        }

        public class CheckListAdapter
        extends RecyclerView.Adapter<ViewHolder> {
            public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
                ViewHolder viewHolder = new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.alivc_check_list_item, parent, false));
                return viewHolder;
            }

            public void onBindViewHolder(ViewHolder holder, final int position) {
                holder.type.setText((CharSequence)((BottomCheckListItemData)((BottomListCheckBuilder)BottomListCheckBuilder.this).mItems.get((int)position)).type);
                holder.value.setText((CharSequence)((BottomCheckListItemData)((BottomListCheckBuilder)BottomListCheckBuilder.this).mItems.get((int)position)).value);
                holder.bottomDialogListItem.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        BottomListCheckBuilder.this.onCheckItemClickListener.onClick(BottomListCheckBuilder.this.alivcCheckItemDialog, v, position, ((BottomCheckListItemData)((BottomListCheckBuilder)BottomListCheckBuilder.this).mItems.get((int)position)).tag);
                    }
                });
            }

            public int getItemCount() {
                return BottomListCheckBuilder.this.mItems.size();
            }

            public int getItemViewType(int position) {
                return super.getItemViewType(position);
            }

            public class ViewHolder
            extends RecyclerView.ViewHolder {
                LinearLayout bottomDialogListItem;
                TextView type;
                TextView value;

                public ViewHolder(View itemView) {
                    super(itemView);
                    this.bottomDialogListItem = (LinearLayout)itemView.findViewById(R.id.bottom_dialog_list_item);
                    this.type = (TextView)itemView.findViewById(R.id.bottom_dialog_list_item_type);
                    this.value = (TextView)itemView.findViewById(R.id.bottom_dialog_list_item_value);
                }
            }
        }

        private static class BottomCheckListItemData {
            String type;
            String value;
            String tag;

            public BottomCheckListItemData(String type, String value, String tag) {
                this.type = type;
                this.value = value;
                this.tag = tag;
            }
        }

        public static interface OnCheckItemClickListener {
            public void onClick(AlivcCheckItemDialog var1, View var2, int var3, String var4);
        }
    }

    public static interface OnChoiceItemListener {
        public void onShow();
    }
}

