/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.choice;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.annotation.NonNull;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import java.lang.ref.WeakReference;

public class AlivcShowMoreDialog
extends Dialog {
    private static final int ANIMATION_DURATION = 200;
    private View mContentView;
    private AliyunScreenMode screenMode;
    private WeakReference<Context> activityWeakReference;
    private boolean mIsAnimating = false;

    public AlivcShowMoreDialog(@NonNull Context context) {
        this(context, AliyunScreenMode.Full);
    }

    public AlivcShowMoreDialog(Context context, AliyunScreenMode aliyunScreenMode) {
        super(context, R.style.addDownloadDialog);
        this.screenMode = aliyunScreenMode;
        this.activityWeakReference = new WeakReference<Context>(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        this.setLayoutBySreenMode(this.screenMode);
    }

    public void setContentView(@NonNull View view) {
        this.mContentView = view;
        super.setContentView(view);
    }

    public void setLayoutBySreenMode(AliyunScreenMode aliyunScreenMode) {
        if (aliyunScreenMode == AliyunScreenMode.Small) {
            int screenHeight;
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            params.height = -2;
            params.gravity = 81;
            int screenWidth = ScreenUtils.getWidth((Context)this.getContext());
            params.width = screenWidth < (screenHeight = ScreenUtils.getHeight((Context)this.getContext())) ? screenWidth : screenHeight;
            this.getWindow().setAttributes(params);
            this.setCanceledOnTouchOutside(true);
        } else {
            int screenHeight;
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            params.height = -1;
            params.gravity = 5;
            int screenWidth = ScreenUtils.getWidth((Context)this.getContext());
            params.width = screenWidth < (screenHeight = ScreenUtils.getHeight((Context)this.getContext())) ? screenWidth : screenHeight;
            this.getWindow().setAttributes(params);
            this.setCanceledOnTouchOutside(true);
        }
    }

    private void animateUp() {
        if (this.mContentView != null) {
            return;
        }
        TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation((Animation)translateAnimation);
        animationSet.addAnimation((Animation)alphaAnimation);
        animationSet.setInterpolator((Interpolator)new DecelerateInterpolator());
        animationSet.setDuration(200L);
        animationSet.setFillAfter(true);
        this.mContentView.startAnimation((Animation)animationSet);
    }

    private void animateDown() {
        if (this.mContentView == null) {
            return;
        }
        TranslateAnimation translate = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        AnimationSet set = new AnimationSet(true);
        set.addAnimation((Animation)translate);
        set.addAnimation((Animation)alpha);
        set.setInterpolator((Interpolator)new DecelerateInterpolator());
        set.setDuration(200L);
        set.setFillAfter(true);
        set.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                AlivcShowMoreDialog.this.mIsAnimating = true;
            }

            public void onAnimationEnd(Animation animation) {
                AlivcShowMoreDialog.this.mIsAnimating = false;
                AlivcShowMoreDialog.this.mContentView.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AlivcShowMoreDialog.super.dismiss();
                        }
                        catch (Exception e) {
                            Log.w((String)"Test", (String)("dismiss error\n" + Log.getStackTraceString((Throwable)e)));
                        }
                    }
                });
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mContentView.startAnimation((Animation)set);
    }

    private void fullScreenImmersive(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            int uiOptions = 5894;
            view.setSystemUiVisibility(uiOptions);
        }
    }

    public void show() {
        this.getWindow().setFlags(8, 8);
        super.show();
        this.fullScreenImmersive(this.getWindow().getDecorView());
        this.getWindow().clearFlags(8);
        this.animateUp();
    }

    public void dismiss() {
        super.dismiss();
    }
}

