/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.function;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.Html;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.svideo.common.utils.image.ImageLoaderOptions;
import java.lang.ref.WeakReference;

public class AdvPictureView
extends RelativeLayout {
    private ImageView mAdvImageView;
    private TextView mCountDownTextView;
    private RelativeLayout mAdvPictureRootRelativeLayout;
    private OnAdvPictureListener mOnAdvPictureListener;
    private boolean isShowCenterAdv = false;
    private ImageView mBackImageView;
    private int mCountDownTime = 5;
    private int mCurrentCountDownTime = 5;
    private String mAdvPictureUrl;
    private boolean mIsCountDown;
    private CountDownHandler mCountDownHandler;
    private int mWidth;
    private int mHeight;

    public AdvPictureView(Context context) {
        super(context);
        this.init(context);
    }

    public AdvPictureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AdvPictureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.alivc_view_adv_picture, (ViewGroup)this, true);
        this.findAllView();
        this.initCountDown();
        this.initListener();
    }

    private void findAllView() {
        this.mAdvImageView = (ImageView)this.findViewById(R.id.iv_adv);
        this.mBackImageView = (ImageView)this.findViewById(R.id.alivc_back);
        this.mCountDownTextView = (TextView)this.findViewById(R.id.tv_count_down);
        this.mAdvPictureRootRelativeLayout = (RelativeLayout)this.findViewById(R.id.rl_adv_picture_root);
    }

    private void initPicture() {
        if (this.mAdvImageView != null) {
            new ImageLoaderImpl().loadImage(this.getContext(), this.mAdvPictureUrl, new ImageLoaderOptions.Builder().crossFade().centerCrop().error(R.drawable.alivc_player_adv_picture).build()).into(this.mAdvImageView);
        }
    }

    private void initCountDown() {
        this.mCountDownHandler = new CountDownHandler(this);
        this.mCountDownHandler.sendEmptyMessage(this.mCountDownTime);
    }

    private void initListener() {
        this.mCountDownTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AdvPictureView.this.mOnAdvPictureListener != null) {
                    if (AdvPictureView.this.mCountDownHandler != null) {
                        AdvPictureView.this.mCountDownHandler.removeCallbacksAndMessages(null);
                    }
                    AdvPictureView.this.mIsCountDown = false;
                    AdvPictureView.this.mOnAdvPictureListener.close();
                }
            }
        });
        this.mAdvImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AdvPictureView.this.mOnAdvPictureListener != null) {
                    AdvPictureView.this.mOnAdvPictureListener.onClick();
                }
            }
        });
        this.mBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AdvPictureView.this.mOnAdvPictureListener != null) {
                    AdvPictureView.this.mOnAdvPictureListener.finish();
                }
            }
        });
    }

    public void hideAll() {
        if (this.mAdvPictureRootRelativeLayout != null) {
            this.mAdvPictureRootRelativeLayout.setVisibility(8);
            this.isShowCenterAdv = false;
        }
    }

    public void showAll() {
        this.recovery();
        if (this.mAdvPictureRootRelativeLayout != null && !this.mAdvPictureRootRelativeLayout.isShown()) {
            this.mAdvPictureRootRelativeLayout.setVisibility(0);
        }
        if (this.mBackImageView != null) {
            this.mBackImageView.setVisibility(0);
        }
    }

    public void cancel() {
        if (this.mCountDownHandler != null) {
            this.mCountDownHandler.removeCallbacksAndMessages(null);
        }
    }

    public void reStart() {
        if (this.mCountDownHandler != null) {
            this.mCountDownHandler.sendEmptyMessage(this.mCurrentCountDownTime);
        }
    }

    public void stop() {
        this.cancel();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.isShowCenterAdv) {
            this.showCenterAdv();
        }
    }

    public void recovery() {
        if (this.mAdvImageView != null) {
            ViewGroup.LayoutParams layoutParams = this.mAdvImageView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -1;
            this.mAdvImageView.setLayoutParams(layoutParams);
        }
        if (this.mCountDownTextView != null) {
            this.mCountDownTextView.setVisibility(0);
        }
        if (this.mCountDownHandler != null) {
            this.mCountDownHandler.removeCallbacksAndMessages(null);
        }
        this.mCountDownTime = 5;
        this.initCountDown();
        this.isShowCenterAdv = false;
    }

    public void showCenterAdv() {
        if (this.mAdvImageView != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mAdvImageView.getLayoutParams();
            layoutParams.height = this.mHeight / 2;
            layoutParams.width = this.mWidth / 2;
            layoutParams.addRule(13);
            this.mAdvImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.mAdvPictureRootRelativeLayout != null) {
                this.mAdvPictureRootRelativeLayout.setVisibility(0);
            }
            if (this.mCountDownTextView != null) {
                this.mCountDownTextView.setVisibility(8);
            }
            this.mAdvImageView.invalidate();
            this.isShowCenterAdv = true;
        }
        if (this.mBackImageView != null) {
            this.mBackImageView.setVisibility(8);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mCountDownHandler != null) {
            this.mCountDownHandler.removeCallbacksAndMessages(null);
        }
    }

    public void setOnAdvPictureListener(OnAdvPictureListener listener) {
        this.mOnAdvPictureListener = listener;
    }

    public void setAdvPictureUrl(String url) {
        this.mAdvPictureUrl = url;
        this.initPicture();
    }

    public boolean isInCountDown() {
        return this.mIsCountDown;
    }

    private static class CountDownHandler
    extends Handler {
        private WeakReference<AdvPictureView> weakreference;

        public CountDownHandler(AdvPictureView mAdvPictureView) {
            this.weakreference = new WeakReference<AdvPictureView>(mAdvPictureView);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            AdvPictureView advPictureView = (AdvPictureView)((Object)this.weakreference.get());
            if (advPictureView != null) {
                int countDownTime = msg.what;
                advPictureView.mCurrentCountDownTime = countDownTime;
                if (countDownTime <= 0) {
                    advPictureView.mCountDownHandler.removeCallbacksAndMessages(null);
                    if (advPictureView.mOnAdvPictureListener != null) {
                        advPictureView.mIsCountDown = false;
                        advPictureView.mOnAdvPictureListener.close();
                    }
                    return;
                }
                advPictureView.mIsCountDown = true;
                String content = "<font color='#00c1de'>" + countDownTime + "&nbsp;&nbsp;</font><font color='#FFFFFF'>" + advPictureView.getContext().getString(R.string.alivc_check_list_close) + "</font>";
                advPictureView.mCountDownTextView.setText((CharSequence)Html.fromHtml((String)content));
                Message mMsg = Message.obtain();
                mMsg.what = --countDownTime;
                advPictureView.mCountDownHandler.sendMessageDelayed(mMsg, 1000L);
            }
        }
    }

    public static interface OnAdvPictureListener {
        public void finish();

        public void close();

        public void onClick();
    }
}

