/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.trailers;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;

public class TrailersView
extends RelativeLayout {
    private View view;
    private TextView mTrailerOpenTextView;
    private LinearLayout mTrailerPlayAgainRootView;
    public OnTrailerViewClickListener mListener;
    private LinearLayout mTrailerPlayTipsRoot;
    private FrameLayout mTrailerTipsRootView;

    public TrailersView(Context context) {
        super(context);
        this.init();
    }

    public TrailersView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TrailersView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.alivc_trailers_view_layout, (ViewGroup)this, true);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.mTrailerOpenTextView = (TextView)this.view.findViewById(R.id.tv_trailer_open);
        this.mTrailerTipsRootView = (FrameLayout)this.view.findViewById(R.id.ll_trailer_tips_root);
        this.mTrailerPlayTipsRoot = (LinearLayout)this.view.findViewById(R.id.ll_trailer_play_tips_root);
        this.mTrailerPlayAgainRootView = (LinearLayout)this.view.findViewById(R.id.ll_trailer_play_again);
    }

    private void initListener() {
        this.mTrailerOpenTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TrailersView.this.mListener != null) {
                    TrailersView.this.mListener.onOpenVipClick();
                }
            }
        });
        this.mTrailerPlayAgainRootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TrailersView.this.mListener != null) {
                    TrailersView.this.mListener.onTrailerPlayAgainClick();
                }
            }
        });
    }

    public void hideAll() {
        if (this.mTrailerPlayTipsRoot != null) {
            this.mTrailerPlayTipsRoot.setVisibility(8);
        }
        if (this.mTrailerTipsRootView != null) {
            this.mTrailerTipsRootView.setVisibility(8);
        }
    }

    public void trailerPlayTipsIsShow(boolean isShow) {
        if (this.mTrailerPlayTipsRoot != null) {
            this.mTrailerPlayTipsRoot.setVisibility(isShow ? 0 : 8);
        }
        if (this.mTrailerTipsRootView != null) {
            this.mTrailerTipsRootView.setVisibility(isShow ? 8 : 0);
        }
    }

    public void setOnTrailerViewClickListener(OnTrailerViewClickListener listener) {
        this.mListener = listener;
    }

    public static interface OnTrailerViewClickListener {
        public void onTrailerPlayAgainClick();

        public void onOpenVipClick();
    }
}

