/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.okhttp;

import android.os.Handler;
import android.os.Looper;
import com.aliyun.svideo.common.okhttp.interceptor.LoggingIntcepetor;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class AlivcOkHttpClient {
    private static AlivcOkHttpClient alivcOkHttpClient;
    private OkHttpClient okHttpClient;
    private OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new LoggingIntcepetor());
    private Handler handler = new Handler(Looper.getMainLooper());

    private AlivcOkHttpClient() {
        this.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlivcOkHttpClient getInstance() {
        if (alivcOkHttpClient != null) return alivcOkHttpClient;
        Class<AlivcOkHttpClient> clazz = AlivcOkHttpClient.class;
        synchronized (AlivcOkHttpClient.class) {
            if (alivcOkHttpClient != null) return alivcOkHttpClient;
            alivcOkHttpClient = new AlivcOkHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return alivcOkHttpClient;
        }
    }

    private void build() {
        this.okHttpBuilder.connectTimeout(10L, TimeUnit.SECONDS);
        this.okHttpBuilder.writeTimeout(10L, TimeUnit.SECONDS);
        this.okHttpBuilder.readTimeout(10L, TimeUnit.SECONDS);
        this.okHttpBuilder.certificatePinner(CertificatePinner.DEFAULT);
        this.okHttpBuilder.hostnameVerifier(SSLSocketClient.getHostnameVerifier());
        this.okHttpBuilder.sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), SSLSocketClient.getX509TrustManager());
        this.okHttpClient = this.okHttpBuilder.build();
    }

    public FormBody formBody(Map<String, String> param) {
        Set<String> keys;
        FormBody.Builder builder = new FormBody.Builder();
        if (param != null && !(keys = param.keySet()).isEmpty()) {
            for (String key : keys) {
                String value = param.get(key);
                if (value == null) continue;
                builder.add(key, value);
            }
        }
        return builder.build();
    }

    public String urlWithParam(String url, Map<String, String> params) {
        Set<String> keys;
        if (params != null && !(keys = params.keySet()).isEmpty()) {
            StringBuilder paramsBuilder = new StringBuilder();
            boolean needAnd = false;
            for (String key : keys) {
                if (needAnd) {
                    paramsBuilder.append("&");
                }
                paramsBuilder.append(key).append("=").append(params.get(key));
                needAnd = true;
            }
            return url + "?" + paramsBuilder.toString();
        }
        return url;
    }

    public void get(String url, HttpCallBack httpCallBack) {
        Request request = new Request.Builder().url(url).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new StringCallBack(request, httpCallBack));
    }

    public void get(String url, HashMap<String, String> params, HttpCallBack httpCallBack) {
        Request request = new Request.Builder().url(this.urlWithParam(url, params)).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new StringCallBack(request, httpCallBack));
    }

    public void post(String url, Map<String, String> params, HttpCallBack httpCallBack) {
        Request request = new Request.Builder().url(url).post((RequestBody)this.formBody(params)).build();
        this.okHttpClient.newCall(request).enqueue((Callback)new StringCallBack(request, httpCallBack));
    }

    public static class SSLSocketClient {
        public static SSLSocketFactory getSSLSocketFactory() {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, SSLSocketClient.getTrustManager(), new SecureRandom());
                return sslContext.getSocketFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static TrustManager[] getTrustManager() {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            return trustAllCerts;
        }

        public static HostnameVerifier getHostnameVerifier() {
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
            return hostnameVerifier;
        }

        public static X509TrustManager getX509TrustManager() {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            return x509TrustManager;
        }
    }

    public static interface HttpCallBack {
        public void onError(Request var1, IOException var2);

        public void onSuccess(Request var1, String var2);
    }

    class StringCallBack
    implements Callback {
        private HttpCallBack httpCallBack;
        private Request request;

        public StringCallBack(Request request, HttpCallBack httpCallBack) {
            this.request = request;
            this.httpCallBack = httpCallBack;
        }

        public void onFailure(Call call, IOException e) {
            final IOException fe = e;
            if (this.httpCallBack != null) {
                AlivcOkHttpClient.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        StringCallBack.this.httpCallBack.onError(StringCallBack.this.request, fe);
                    }
                });
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            final String result = response.body().string();
            try {
                final JSONObject jsonObject = new JSONObject(result);
                if ("200".equals(jsonObject.getString("code"))) {
                    if (this.httpCallBack != null) {
                        AlivcOkHttpClient.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                StringCallBack.this.httpCallBack.onSuccess(StringCallBack.this.request, result);
                            }
                        });
                    } else {
                        AlivcOkHttpClient.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                StringCallBack.this.httpCallBack.onError(StringCallBack.this.request, new IOException("json error"));
                            }
                        });
                    }
                } else if (this.httpCallBack != null) {
                    AlivcOkHttpClient.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StringCallBack.this.httpCallBack.onError(StringCallBack.this.request, new IOException(jsonObject.getString("message")));
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

