/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.utils.DensityUtils;
import com.aliyun.svideo.common.widget.QMUILoadingView;

public class TipDialog
extends Dialog {
    public TipDialog(Context context) {
        this(context, R.style.TipDialog);
    }

    public TipDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.setCanceledOnTouchOutside(false);
    }

    public static class Builder {
        private Context mContext;
        public static final int TYPE_DEFAILD = 0;
        public static final int TYPE_MESSAGE_ONLY = 1;
        public static final int TYPE_IMG_ONLY = 5;
        public static final int TYPE_LOADING = 2;
        public static final int TYPE_SUCCESS = 3;
        public static final int TYPE_FAIL = 4;
        private int iconId;
        private String message = "";
        private int type = 0;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public TipDialog create() {
            TipDialog dialog = new TipDialog(this.mContext);
            dialog.setCancelable(true);
            dialog.setContentView(R.layout.alivc_common_dialog_tip);
            ViewGroup contentWrap = (ViewGroup)dialog.findViewById(R.id.contentWrap);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)contentWrap.getLayoutParams();
            switch (this.type) {
                case 0: {
                    params.width = DensityUtils.dip2px(this.mContext, 300.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 180.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (this.iconId != 0) {
                        this.addImageView(contentWrap, this.iconId);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.message)) break;
                    this.addTextView(contentWrap);
                    break;
                }
                case 1: {
                    contentWrap.setBackgroundResource(R.drawable.alivc_dialog_bg_translucent);
                    params.width = DensityUtils.dip2px(this.mContext, 150.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 90.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.addTextView(contentWrap);
                    break;
                }
                case 5: {
                    contentWrap.setBackgroundResource(R.drawable.alivc_dialog_bg_translucent);
                    params.width = DensityUtils.dip2px(this.mContext, 150.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 90.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.addImageView(contentWrap, this.iconId);
                    break;
                }
                case 2: {
                    contentWrap.setBackgroundResource(R.drawable.alivc_dialog_bg_translucent);
                    params.width = DensityUtils.dip2px(this.mContext, 150.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 90.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.addLoadingView(contentWrap);
                    if (TextUtils.isEmpty((CharSequence)this.message)) {
                        this.addTextView(contentWrap, this.mContext.getResources().getString(R.string.alivc_common_loading));
                        break;
                    }
                    this.addTextView(contentWrap);
                    break;
                }
                case 3: {
                    params.width = DensityUtils.dip2px(this.mContext, 300.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 180.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.addImageView(contentWrap, R.mipmap.icon_delete_tips);
                    if (TextUtils.isEmpty((CharSequence)this.message)) {
                        this.addTextView(contentWrap, this.mContext.getResources().getString(R.string.alivc_common_operate_success));
                        break;
                    }
                    this.addTextView(contentWrap);
                    break;
                }
                case 4: {
                    params.width = DensityUtils.dip2px(this.mContext, 300.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 180.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    this.addImageView(contentWrap, R.mipmap.icon_delete_tips);
                    if (TextUtils.isEmpty((CharSequence)this.message)) {
                        this.addTextView(contentWrap, this.mContext.getResources().getString(R.string.alivc_common_operate_success));
                        break;
                    }
                    this.addTextView(contentWrap);
                    break;
                }
                default: {
                    params.width = DensityUtils.dip2px(this.mContext, 300.0f);
                    params.height = DensityUtils.dip2px(this.mContext, 180.0f);
                    contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
                    if (this.iconId != 0) {
                        this.addImageView(contentWrap, this.iconId);
                    }
                    if (TextUtils.isEmpty((CharSequence)this.message)) break;
                    this.addTextView(contentWrap);
                }
            }
            return dialog;
        }

        private void addTextView(ViewGroup rootView) {
            this.addTextView(rootView, this.message);
        }

        private void addTextView(ViewGroup rootView, String tip) {
            TextView tipView = new TextView(this.mContext);
            LinearLayout.LayoutParams tipViewLP = new LinearLayout.LayoutParams(-2, -2);
            tipViewLP.topMargin = DensityUtils.dip2px(this.mContext, 12.0f);
            tipView.setLayoutParams((ViewGroup.LayoutParams)tipViewLP);
            tipView.setEllipsize(TextUtils.TruncateAt.END);
            tipView.setGravity(17);
            tipView.setMaxLines(2);
            tipView.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.alivc_common_white));
            tipView.setTextSize(2, 14.0f);
            tipView.setText((CharSequence)tip);
            rootView.addView((View)tipView);
        }

        private void addImageView(ViewGroup rootView, int iconId) {
            ImageView imageView = new ImageView(this.mContext);
            LinearLayout.LayoutParams imageViewLP = new LinearLayout.LayoutParams(-2, -2);
            imageView.setLayoutParams((ViewGroup.LayoutParams)imageViewLP);
            imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)iconId));
            rootView.addView((View)imageView);
        }

        private void addLoadingView(ViewGroup rootView) {
            QMUILoadingView loadingView = new QMUILoadingView(this.mContext);
            loadingView.setColor(-1);
            loadingView.setSize(DensityUtils.dip2px(this.mContext, 32.0f));
            LinearLayout.LayoutParams loadingViewLP = new LinearLayout.LayoutParams(-2, -2);
            loadingView.setLayoutParams((ViewGroup.LayoutParams)loadingViewLP);
            rootView.addView((View)loadingView);
        }

        public Builder setIconId(int iconId) {
            this.iconId = iconId;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setType(int type) {
            this.type = type;
            return this;
        }
    }
}

