/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.utils;

import com.aliyun.sdk.utils.VcPlayerLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class HttpClientHelper {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static ExecutorService sThreadCachePool = Executors.newCachedThreadPool();
    private URLConnection urlConnection = null;

    public HttpClientHelper(String serverUrl) {
        this.urlConnection = serverUrl.startsWith("https://") ? this.getHttpsUrlConnection(serverUrl) : (serverUrl.startsWith("http://") ? this.getHttpUrlConnection(serverUrl) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGet() {
        if (this.urlConnection == null) {
            return null;
        }
        InputStream in = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            StringBuilder response = null;
            int responseCode = this.getResponseCode();
            if (responseCode == 200) {
                in = this.urlConnection.getInputStream();
                inputStreamReader = new InputStreamReader(in);
                bufferedReader = new BufferedReader(inputStreamReader);
                response = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                String string2 = response.toString();
                return string2;
            }
            in = this.getErrorStream();
            inputStreamReader = new InputStreamReader(in);
            bufferedReader = new BufferedReader(inputStreamReader);
            response = new StringBuilder();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("StatusCode", responseCode);
            jsonObject.put("ResponseStr", (Object)response.toString());
            String string3 = jsonObject.toString();
            return string3;
        }
        catch (Exception e) {
            VcPlayerLog.d("HttpClientUtil", e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            if (this.urlConnection != null) {
                if (this.urlConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.urlConnection).disconnect();
                } else if (this.urlConnection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)this.urlConnection).disconnect();
                }
            }
        }
        return null;
    }

    private InputStream getErrorStream() {
        InputStream in = null;
        if (this.urlConnection instanceof HttpsURLConnection) {
            in = ((HttpsURLConnection)this.urlConnection).getErrorStream();
        } else if (this.urlConnection instanceof HttpURLConnection) {
            in = ((HttpURLConnection)this.urlConnection).getErrorStream();
        }
        return in;
    }

    private int getResponseCode() throws IOException {
        int responseCode = 0;
        if (this.urlConnection instanceof HttpsURLConnection) {
            responseCode = ((HttpsURLConnection)this.urlConnection).getResponseCode();
        } else if (this.urlConnection instanceof HttpURLConnection) {
            responseCode = ((HttpURLConnection)this.urlConnection).getResponseCode();
        }
        return responseCode;
    }

    public void stop() {
        VcPlayerLog.e("lfj0417_2", "HttpClientHelper stop().... urlConnection = " + this.urlConnection);
        if (this.urlConnection != null) {
            sThreadCachePool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (HttpClientHelper.this.urlConnection instanceof HttpsURLConnection) {
                            VcPlayerLog.e("lfj0417_2", "HttpClientHelper stop().... HttpsURLConnection.disconnect ");
                            ((HttpsURLConnection)HttpClientHelper.this.urlConnection).disconnect();
                        } else if (HttpClientHelper.this.urlConnection instanceof HttpURLConnection) {
                            VcPlayerLog.e("lfj0417_2", "HttpClientHelper stop().... HttpURLConnection.disconnect ");
                            ((HttpURLConnection)HttpClientHelper.this.urlConnection).disconnect();
                        }
                    }
                    catch (Exception e) {
                        VcPlayerLog.e("lfj0417_2", e.getMessage());
                    }
                }
            });
        }
    }

    private URLConnection getHttpUrlConnection(String serverUrl) {
        URLConnection urlConnection = null;
        URL url = null;
        try {
            url = new URL(serverUrl);
            urlConnection = url.openConnection();
            if (!(urlConnection instanceof HttpURLConnection)) {
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urlConnection;
    }

    private URLConnection getHttpsUrlConnection(String serverUrl) {
        URLConnection urlConnection = null;
        URL url = null;
        try {
            url = new URL(serverUrl);
            urlConnection = url.openConnection();
            if (!(urlConnection instanceof HttpsURLConnection)) {
                return null;
            }
            HttpsURLConnection connection = (HttpsURLConnection)urlConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urlConnection;
    }
}

