/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ui.view.seekbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.SeekBar;
import androidx.annotation.RequiresApi;
import com.aliyun.sdk.player.aliyunliveshiftplayer.R;

@SuppressLint(value={"AppCompatCustomView"})
public class LiveSeekBar
extends SeekBar {
    private long currentLiveTime = 0L;
    private long mShiftStartTime = 0L;
    private long mEndTime = 0L;
    private Paint linePaint;

    public LiveSeekBar(Context context) {
        super(context);
        this.init();
    }

    public LiveSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LiveSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.linePaint = new Paint();
        this.linePaint.setColor(this.getResources().getColor(R.color.alivc_common_bg_red));
        this.linePaint.setAntiAlias(true);
    }

    public void updateRange(long shitStartTime, long endTime) {
        this.mShiftStartTime = shitStartTime;
        this.mEndTime = endTime;
        this.setMax((int)(this.mEndTime - shitStartTime));
    }

    public void setLiveTime(long time) {
        this.currentLiveTime = time;
        this.setSecondaryProgress((int)(this.currentLiveTime - this.mShiftStartTime));
    }

    public void setPlayProgress(long currentTime) {
        this.setProgress((int)(currentTime - this.mShiftStartTime));
    }

    @RequiresApi(api=16)
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawLine(canvas);
        this.drawThumb(canvas);
    }

    private void drawLine(Canvas canvas) {
        int offsetX = this.getPaddingLeft() + this.getPaddingRight();
        int width = this.getWidth() - offsetX;
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            float startX;
            float lineWith = (float)width / 100.0f;
            float lineHeight = height;
            float stopX = startX = (float)this.getPaddingLeft() + (float)this.getSecondaryProgress() * 1.0f / (float)this.getMax() * (float)width;
            float startY = 0.0f;
            float stopY = lineHeight;
            this.linePaint.setStrokeWidth(lineWith);
            canvas.drawLine(startX, startY, stopX, stopY, this.linePaint);
        }
    }

    @RequiresApi(api=16)
    void drawThumb(Canvas canvas) {
        Drawable mThumb = this.getThumb();
        if (mThumb != null) {
            int saveCount = canvas.save();
            canvas.translate((float)(this.getPaddingLeft() - this.getThumbOffset()), (float)this.getPaddingTop());
            mThumb.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }
}

