/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.activity;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.util.RegularPatternUtil;
import com.aliyun.vodplayer.R;
import java.util.Locale;

public class AliyunPlayerConfigActivity
extends AppCompatActivity
implements View.OnClickListener {
    private TextView mConfirmTextView;
    private TextView mDefaultConfig;
    private Switch mEnableCacheSwitch;
    private Switch mEnableSeiSwitch;
    private Switch mEnableClearWhenStop;
    private EditText mMaxDelayTimeEditText;
    private EditText mHightBufferLevelEditText;
    private EditText mFirstStartBufferLevelEditText;
    private EditText mMaxBufferPacketDurationEditText;
    private EditText mNetWorkTimeOutEditText;
    private EditText mProbeSizeEditText;
    private EditText mReferrerEditText;
    private EditText mHttpProxyEditText;
    private EditText mRetryCountEditText;
    private EditText mMaxDurationEditText;
    private EditText mMaxSizeEditText;
    private ImageView mBackImageView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_player_config);
        this.initView();
        this.initListener();
        this.initData();
    }

    private void initView() {
        this.mBackImageView = (ImageView)this.findViewById(R.id.iv_back);
        this.mDefaultConfig = (TextView)this.findViewById(R.id.tv_default_config);
        this.mConfirmTextView = (TextView)this.findViewById(R.id.tv_confirm_config);
        this.mEnableSeiSwitch = (Switch)this.findViewById(R.id.switch_enable_sei);
        this.mEnableCacheSwitch = (Switch)this.findViewById(R.id.switch_enable_cache);
        this.mEnableClearWhenStop = (Switch)this.findViewById(R.id.switch_enable_clear_when_stop);
        this.mReferrerEditText = (EditText)this.findViewById(R.id.et_referrer);
        this.mProbeSizeEditText = (EditText)this.findViewById(R.id.et_probe_size);
        this.mHttpProxyEditText = (EditText)this.findViewById(R.id.et_http_proxy);
        this.mRetryCountEditText = (EditText)this.findViewById(R.id.et_retry_count);
        this.mMaxDelayTimeEditText = (EditText)this.findViewById(R.id.et_max_delay_time);
        this.mNetWorkTimeOutEditText = (EditText)this.findViewById(R.id.et_net_work_time_out);
        this.mHightBufferLevelEditText = (EditText)this.findViewById(R.id.et_high_buffer_level);
        this.mFirstStartBufferLevelEditText = (EditText)this.findViewById(R.id.et_first_start_buffer_level);
        this.mMaxBufferPacketDurationEditText = (EditText)this.findViewById(R.id.et_max_buffer_packet_duration);
        this.mMaxSizeEditText = (EditText)this.findViewById(R.id.et_max_size);
        this.mMaxDurationEditText = (EditText)this.findViewById(R.id.et_max_duration);
    }

    private void initListener() {
        this.mBackImageView.setOnClickListener((View.OnClickListener)this);
        this.mDefaultConfig.setOnClickListener((View.OnClickListener)this);
        this.mConfirmTextView.setOnClickListener((View.OnClickListener)this);
    }

    private void initData() {
        this.mReferrerEditText.setText((CharSequence)GlobalPlayerConfig.PlayConfig.mReferrer);
        this.mHttpProxyEditText.setText((CharSequence)GlobalPlayerConfig.PlayConfig.mHttpProxy);
        this.mProbeSizeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mMaxProbeSize));
        this.mMaxDelayTimeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mMaxDelayTime));
        this.mRetryCountEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mNetworkRetryCount));
        this.mNetWorkTimeOutEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mNetworkTimeout));
        this.mHightBufferLevelEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mHighBufferDuration));
        this.mFirstStartBufferLevelEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mStartBufferDuration));
        this.mMaxBufferPacketDurationEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.mMaxBufferDuration));
        this.mEnableCacheSwitch.setChecked(GlobalPlayerConfig.PlayCacheConfig.mEnableCache);
        this.mEnableSeiSwitch.setChecked(GlobalPlayerConfig.PlayConfig.mEnableSei);
        this.mEnableClearWhenStop.setChecked(GlobalPlayerConfig.PlayConfig.mEnableClearWhenStop);
        this.mMaxSizeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB));
        this.mMaxDurationEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS));
        if (GlobalPlayerConfig.mUrlPath.startsWith("artp")) {
            this.mMaxDelayTimeEditText.setText((CharSequence)"100");
        } else if (GlobalPlayerConfig.mUrlPath.startsWith("artc")) {
            this.mMaxDelayTimeEditText.setText((CharSequence)"1000");
            this.mHightBufferLevelEditText.setText((CharSequence)"10");
            this.mFirstStartBufferLevelEditText.setText((CharSequence)"10");
        }
    }

    private void restoreData() {
        this.mReferrerEditText.setText((CharSequence)"");
        this.mHttpProxyEditText.setText((CharSequence)"");
        this.mProbeSizeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", -1));
        this.mMaxDelayTimeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.DEFAULT_MAX_DELAY_TIME));
        this.mRetryCountEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", 2));
        this.mNetWorkTimeOutEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", 15000));
        this.mHightBufferLevelEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.DEFAULT_HIGH_BUFFER_DURATION));
        this.mFirstStartBufferLevelEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.DEFAULT_START_BUFFER_DURATION));
        this.mMaxBufferPacketDurationEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.PlayConfig.DEFAULT_MAX_BUFFER_DURATION));
        this.mEnableCacheSwitch.setChecked(false);
        this.mEnableSeiSwitch.setChecked(false);
        this.mEnableClearWhenStop.setChecked(false);
        this.mMaxSizeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", 200));
        this.mMaxDurationEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", 100));
    }

    public void onClick(View view) {
        if (view == this.mConfirmTextView) {
            this.saveConfig();
            this.finish();
        } else if (view == this.mDefaultConfig) {
            this.restoreData();
        } else if (view == this.mBackImageView) {
            this.finish();
        }
    }

    private void saveConfig() {
        GlobalPlayerConfig.PlayConfig.mReferrer = this.mReferrerEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mHttpProxy = this.mHttpProxyEditText.getText().toString();
        String maxDelayTime = this.mMaxDelayTimeEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mMaxDelayTime = TextUtils.isEmpty((CharSequence)maxDelayTime) ? GlobalPlayerConfig.PlayConfig.DEFAULT_MAX_DELAY_TIME : Integer.valueOf(maxDelayTime);
        String probeSize = this.mProbeSizeEditText.getText().toString();
        if (!RegularPatternUtil.isNumber((String)probeSize)) {
            probeSize = "-1";
        }
        GlobalPlayerConfig.PlayConfig.mMaxProbeSize = TextUtils.isEmpty((CharSequence)probeSize) ? 0 : Integer.valueOf(probeSize);
        String netWorkTimeOut = this.mNetWorkTimeOutEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mNetworkTimeout = TextUtils.isEmpty((CharSequence)netWorkTimeOut) ? 15000 : Integer.valueOf(netWorkTimeOut);
        String retryCount = this.mRetryCountEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mNetworkRetryCount = TextUtils.isEmpty((CharSequence)retryCount) ? 2 : Integer.valueOf(retryCount);
        String maxBufferDuration = this.mMaxBufferPacketDurationEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mMaxBufferDuration = TextUtils.isEmpty((CharSequence)maxBufferDuration) ? GlobalPlayerConfig.PlayConfig.DEFAULT_MAX_BUFFER_DURATION : Integer.valueOf(maxBufferDuration);
        String heightBufferLevel = this.mHightBufferLevelEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mHighBufferDuration = TextUtils.isEmpty((CharSequence)heightBufferLevel) ? GlobalPlayerConfig.PlayConfig.DEFAULT_HIGH_BUFFER_DURATION : Integer.valueOf(heightBufferLevel);
        String firstStartBufferLevel = this.mFirstStartBufferLevelEditText.getText().toString();
        GlobalPlayerConfig.PlayConfig.mStartBufferDuration = TextUtils.isEmpty((CharSequence)firstStartBufferLevel) ? GlobalPlayerConfig.PlayConfig.DEFAULT_START_BUFFER_DURATION : Integer.valueOf(firstStartBufferLevel);
        GlobalPlayerConfig.PlayConfig.mEnableSei = this.mEnableSeiSwitch.isChecked();
        GlobalPlayerConfig.PlayConfig.mEnableClearWhenStop = this.mEnableClearWhenStop.isChecked();
        GlobalPlayerConfig.PlayCacheConfig.mEnableCache = this.mEnableCacheSwitch.isChecked();
        String maxSizeMB = this.mMaxSizeEditText.getText().toString();
        GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB = TextUtils.isEmpty((CharSequence)maxSizeMB) ? 200 : Integer.valueOf(maxSizeMB);
        String maxDuration = this.mMaxDurationEditText.getText().toString();
        GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS = TextUtils.isEmpty((CharSequence)maxDuration) ? 100 : Integer.valueOf(maxDuration);
    }
}

