/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.aliyunplayerbase.bean.AliyunPlayAuth;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import java.util.Locale;

public class AliyunPlayerTypeAuthFragment
extends BaseFragment {
    private EditText mPlayAuthRegionEditText;
    private EditText mPlayAuthVidEditText;
    private EditText mPlayAuthEditText;
    private EditText mPlayAuthPreviewTimeEditText;
    private String mVid;
    private String mPlayAuth;
    private String mRegion;
    private String mPreviewTime;
    private TextView mRefreshTextView;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_aliyun_auth_player_type, container, false);
        this.mPlayAuthEditText = (EditText)view.findViewById(R.id.et_auth);
        this.mRefreshTextView = (TextView)view.findViewById(R.id.tv_refresh);
        this.mPlayAuthVidEditText = (EditText)view.findViewById(R.id.et_auth_vid);
        this.mPlayAuthRegionEditText = (EditText)view.findViewById(R.id.et_auth_region);
        this.mPlayAuthPreviewTimeEditText = (EditText)view.findViewById(R.id.et_auth_preview_time);
        this.initData();
        this.initListener();
        if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mVid)) {
            this.defaultPlayInfo();
        }
        return view;
    }

    private void initData() {
        this.mPlayAuthEditText.setText((CharSequence)GlobalPlayerConfig.mPlayAuth);
        this.mPlayAuthVidEditText.setText((CharSequence)GlobalPlayerConfig.mVid);
        this.mPlayAuthRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
        this.mPlayAuthPreviewTimeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.mPreviewTime));
    }

    private void initListener() {
        this.mRefreshTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AliyunPlayerTypeAuthFragment.this.mVid = AliyunPlayerTypeAuthFragment.this.mPlayAuthVidEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)AliyunPlayerTypeAuthFragment.this.mVid)) {
                    ToastUtils.show((Context)AliyunPlayerTypeAuthFragment.this.getContext(), (int)R.string.alivc_refresh_vid_empty);
                    return;
                }
                AliyunPlayerTypeAuthFragment.this.getVideoPlayAuthInfoWithVideoId(AliyunPlayerTypeAuthFragment.this.mVid);
            }
        });
    }

    private void getVideoPlayAuthInfo() {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayAuthInfo(new GetAuthInformation.OnGetPlayAuthInfoListener(){

            public void onGetPlayAuthError(String msg) {
                ToastUtils.show((Context)AliyunPlayerTypeAuthFragment.this.getContext(), (String)msg);
            }

            public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeAuthFragment.this.mPlayAuthEditText.setText((CharSequence)dataBean.getPlayAuth());
                    AliyunPlayerTypeAuthFragment.this.mPlayAuthVidEditText.setText((CharSequence)dataBean.getVideoMeta().getVideoId());
                    AliyunPlayerTypeAuthFragment.this.mPlayAuthRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
                }
            }
        });
    }

    private void getVideoPlayAuthInfoWithVideoId(String videoId) {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayAuthInfoWithVideoId(videoId, new GetAuthInformation.OnGetPlayAuthInfoListener(){

            public void onGetPlayAuthError(String msg) {
                if (AliyunPlayerTypeAuthFragment.this.getContext() != null) {
                    ToastUtils.show((Context)AliyunPlayerTypeAuthFragment.this.getContext(), (String)msg);
                }
            }

            public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeAuthFragment.this.mPlayAuthEditText.setText((CharSequence)dataBean.getPlayAuth());
                    AliyunPlayerTypeAuthFragment.this.mPlayAuthRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
                }
            }
        });
    }

    private void getInputContent() {
        this.mVid = this.mPlayAuthVidEditText.getText().toString();
        this.mPlayAuth = this.mPlayAuthEditText.getText().toString();
        this.mRegion = this.mPlayAuthRegionEditText.getText().toString();
        this.mPreviewTime = this.mPlayAuthPreviewTimeEditText.getText().toString();
    }

    private void setGlobalConfig() {
        this.getInputContent();
        GlobalPlayerConfig.mVid = this.mVid;
        GlobalPlayerConfig.mRegion = this.mRegion;
        GlobalPlayerConfig.mPlayAuth = this.mPlayAuth;
        GlobalPlayerConfig.mPreviewTime = Integer.valueOf(TextUtils.isEmpty((CharSequence)this.mPreviewTime) ? "-1" : this.mPreviewTime);
    }

    @Override
    public void defaultPlayInfo() {
        this.getVideoPlayAuthInfo();
    }

    @Override
    public void confirmPlayInfo() {
        this.setGlobalConfig();
        GlobalPlayerConfig.AUTH_TYPE_CHECKED = true;
    }
}

