/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.aliyunplayerbase.bean.AliyunMps;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import java.util.Locale;

public class AliyunPlayerTypeMpsFragment
extends BaseFragment {
    private EditText mMpsVidEditText;
    private EditText mMpsRegionEditText;
    private EditText mMpsPlayDomainEditText;
    private EditText mMpsMtsHlsTokenEditText;
    private EditText mMpsPreviewTimeEditText;
    private EditText mMpsAccessKeyIdEditText;
    private EditText mMpsSecurityTokenEditText;
    private EditText mMpsAccessKeySecretEditText;
    private EditText mMpsAuthInfoEditText;
    private String mVid;
    private String mRegion;
    private String mPlayDomain;
    private String mMtsHlsToken;
    private String mPreviewTime;
    private String mAccessKeyId;
    private String mSecurityToken;
    private String mAccessKeySecret;
    private String mAuthInfo;
    private TextView mRefreshTextView;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_aliyun_mps_player_type, container, false);
        this.mMpsVidEditText = (EditText)view.findViewById(R.id.et_mps_vid);
        this.mRefreshTextView = (TextView)view.findViewById(R.id.tv_refresh);
        this.mMpsRegionEditText = (EditText)view.findViewById(R.id.et_mps_region);
        this.mMpsAuthInfoEditText = (EditText)view.findViewById(R.id.et_mps_auth_info);
        this.mMpsPlayDomainEditText = (EditText)view.findViewById(R.id.et_mps_play_domain);
        this.mMpsMtsHlsTokenEditText = (EditText)view.findViewById(R.id.et_mps_mts_hls_token);
        this.mMpsPreviewTimeEditText = (EditText)view.findViewById(R.id.et_preview_time);
        this.mMpsAccessKeyIdEditText = (EditText)view.findViewById(R.id.et_mps_access_key_id);
        this.mMpsSecurityTokenEditText = (EditText)view.findViewById(R.id.et_mps_security_token);
        this.mMpsAccessKeySecretEditText = (EditText)view.findViewById(R.id.et_mps_access_key_secret);
        this.initData();
        this.initListener();
        if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mVid)) {
            this.defaultPlayInfo();
        }
        return view;
    }

    private void getVideoPlayMpsInfo() {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayMpsInfo(new GetAuthInformation.OnGetMpsInfoListener(){

            public void onGetMpsError(String msg) {
                if (AliyunPlayerTypeMpsFragment.this.getContext() != null) {
                    ToastUtils.show((Context)AliyunPlayerTypeMpsFragment.this.getContext(), (String)msg);
                }
            }

            public void onGetMpsSuccess(AliyunMps.MpsBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeMpsFragment.this.mMpsVidEditText.setText((CharSequence)dataBean.getMediaId());
                    AliyunPlayerTypeMpsFragment.this.mMpsRegionEditText.setText((CharSequence)dataBean.getRegionId());
                    AliyunPlayerTypeMpsFragment.this.mMpsAuthInfoEditText.setText((CharSequence)dataBean.getAuthInfo());
                    AliyunPlayerTypeMpsFragment.this.mMpsMtsHlsTokenEditText.setText((CharSequence)dataBean.getHlsUriToken());
                    AliyunPlayerTypeMpsFragment.this.mMpsAccessKeyIdEditText.setText((CharSequence)dataBean.getAkInfo().getAccessKeyId());
                    AliyunPlayerTypeMpsFragment.this.mMpsSecurityTokenEditText.setText((CharSequence)dataBean.getAkInfo().getSecurityToken());
                    AliyunPlayerTypeMpsFragment.this.mMpsAccessKeySecretEditText.setText((CharSequence)dataBean.getAkInfo().getAccessKeySecret());
                }
            }
        });
    }

    private void getVideoPlayMpsInfoWithVideoId(String videoId) {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayMpsInfoWithVideoId(videoId, new GetAuthInformation.OnGetMpsInfoListener(){

            public void onGetMpsError(String msg) {
                ToastUtils.show((Context)AliyunPlayerTypeMpsFragment.this.getContext(), (String)msg);
            }

            public void onGetMpsSuccess(AliyunMps.MpsBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeMpsFragment.this.mMpsRegionEditText.setText((CharSequence)dataBean.getRegionId());
                    AliyunPlayerTypeMpsFragment.this.mMpsAuthInfoEditText.setText((CharSequence)dataBean.getAuthInfo());
                    AliyunPlayerTypeMpsFragment.this.mMpsMtsHlsTokenEditText.setText((CharSequence)dataBean.getHlsUriToken());
                    AliyunPlayerTypeMpsFragment.this.mMpsAccessKeyIdEditText.setText((CharSequence)dataBean.getAkInfo().getAccessKeyId());
                    AliyunPlayerTypeMpsFragment.this.mMpsSecurityTokenEditText.setText((CharSequence)dataBean.getAkInfo().getSecurityToken());
                    AliyunPlayerTypeMpsFragment.this.mMpsAccessKeySecretEditText.setText((CharSequence)dataBean.getAkInfo().getAccessKeySecret());
                }
            }
        });
    }

    private void initData() {
        this.mMpsVidEditText.setText((CharSequence)GlobalPlayerConfig.mVid);
        this.mMpsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mMpsRegion);
        this.mMpsAuthInfoEditText.setText((CharSequence)GlobalPlayerConfig.mMpsAuthInfo);
        this.mMpsMtsHlsTokenEditText.setText((CharSequence)GlobalPlayerConfig.mMpsHlsUriToken);
        this.mMpsAccessKeyIdEditText.setText((CharSequence)GlobalPlayerConfig.mMpsAccessKeyId);
        this.mMpsSecurityTokenEditText.setText((CharSequence)GlobalPlayerConfig.mMpsSecurityToken);
        this.mMpsAccessKeySecretEditText.setText((CharSequence)GlobalPlayerConfig.mMpsAccessKeySecret);
        this.mMpsPreviewTimeEditText.setText((CharSequence)String.format(Locale.getDefault(), "%d", GlobalPlayerConfig.mPreviewTime));
    }

    private void initListener() {
        this.mRefreshTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AliyunPlayerTypeMpsFragment.this.mVid = AliyunPlayerTypeMpsFragment.this.mMpsVidEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)AliyunPlayerTypeMpsFragment.this.mVid)) {
                    ToastUtils.show((Context)AliyunPlayerTypeMpsFragment.this.getContext(), (int)R.string.alivc_refresh_vid_empty);
                    return;
                }
                AliyunPlayerTypeMpsFragment.this.getVideoPlayMpsInfoWithVideoId(AliyunPlayerTypeMpsFragment.this.mVid);
            }
        });
    }

    private void getInputContent() {
        this.mVid = this.mMpsVidEditText.getText().toString();
        this.mRegion = this.mMpsRegionEditText.getText().toString();
        this.mAuthInfo = this.mMpsAuthInfoEditText.getText().toString();
        this.mPlayDomain = this.mMpsPlayDomainEditText.getText().toString();
        this.mMtsHlsToken = this.mMpsMtsHlsTokenEditText.getText().toString();
        this.mPreviewTime = this.mMpsPreviewTimeEditText.getText().toString();
        this.mAccessKeyId = this.mMpsAccessKeyIdEditText.getText().toString();
        this.mSecurityToken = this.mMpsSecurityTokenEditText.getText().toString();
        this.mAccessKeySecret = this.mMpsAccessKeySecretEditText.getText().toString();
    }

    private void setGlobalConfig() {
        this.getInputContent();
        GlobalPlayerConfig.mVid = this.mVid;
        GlobalPlayerConfig.mMpsRegion = this.mRegion;
        GlobalPlayerConfig.mMpsAuthInfo = this.mAuthInfo;
        GlobalPlayerConfig.mMpsHlsUriToken = this.mMtsHlsToken;
        GlobalPlayerConfig.mMpsAccessKeyId = this.mAccessKeyId;
        GlobalPlayerConfig.mMpsSecurityToken = this.mSecurityToken;
        GlobalPlayerConfig.mMpsAccessKeySecret = this.mAccessKeySecret;
        GlobalPlayerConfig.mPreviewTime = Integer.valueOf(TextUtils.isEmpty((CharSequence)this.mPreviewTime) ? "-1" : this.mPreviewTime);
    }

    @Override
    public void defaultPlayInfo() {
        this.getVideoPlayMpsInfo();
    }

    @Override
    public void confirmPlayInfo() {
        this.setGlobalConfig();
        GlobalPlayerConfig.MPS_TYPE_CHECKED = true;
    }
}

