/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

public class WordWrapView
extends ViewGroup {
    private static final int PADDING_HOR = 10;
    private static final int PADDING_VERTICAL = 5;
    private static final int SIDE_MARGIN = 10;
    private static final int TEXT_MARGIN = 10;

    public WordWrapView(Context context) {
        super(context);
    }

    public WordWrapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public WordWrapView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int autualWidth = r - l;
        int x = 10;
        int y = 0;
        int rows = 1;
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            int width = view.getMeasuredWidth();
            int height = view.getMeasuredHeight();
            if ((x += width + 10) > autualWidth) {
                x = width + 10;
                ++rows;
            }
            y = rows * (height + 10);
            if (i == 0) {
                view.layout(x - width - 10, y - height, x - 10, y);
                continue;
            }
            view.layout(x - width, y - height, x, y);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int x = 0;
        int y = 0;
        int rows = 1;
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int actualWidth = specWidth - 20;
        int childCount = this.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            View child = this.getChildAt(index);
            child.setPadding(10, 5, 10, 5);
            child.measure(0, 0);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            if ((x += width + 10) > actualWidth) {
                x = width;
                ++rows;
            }
            y = rows * (height + 10);
        }
        this.setMeasuredDimension(actualWidth, y);
    }
}

