/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.download;

import android.content.Context;
import com.aliyun.player.alivcplayerexpand.util.database.LoadDbDatasListener;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadManager;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.download.AlivcDownloadMediaInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DownloadDataProvider {
    private static volatile DownloadDataProvider instance;
    private AliyunDownloadManager downloadManager;
    private WeakReference<Context> contextWeakReference;
    private List<AliyunDownloadMediaInfo> aliyunDownloadMediaInfos;

    public DownloadDataProvider(Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.downloadManager = AliyunDownloadManager.getInstance((Context)this.contextWeakReference.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadDataProvider getSingleton(Context context) {
        if (instance != null) return instance;
        Class<DownloadDataProvider> clazz = DownloadDataProvider.class;
        synchronized (DownloadDataProvider.class) {
            if (instance != null) return instance;
            instance = new DownloadDataProvider(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void restoreMediaInfo(final LoadDbDatasListener loadDbDatasListener) {
        this.aliyunDownloadMediaInfos = new ArrayList<AliyunDownloadMediaInfo>();
        this.downloadManager.findDatasByDb(new LoadDbDatasListener(){

            @Override
            public void onLoadSuccess(List<AliyunDownloadMediaInfo> dataList) {
                DownloadDataProvider.this.aliyunDownloadMediaInfos.addAll(dataList);
                DownloadDataProvider.this.deleteDumpData();
                loadDbDatasListener.onLoadSuccess(DownloadDataProvider.this.aliyunDownloadMediaInfos);
            }
        });
    }

    public List<AliyunDownloadMediaInfo> getAllDownloadMediaInfo() {
        if (this.aliyunDownloadMediaInfos == null) {
            this.aliyunDownloadMediaInfos = new ArrayList<AliyunDownloadMediaInfo>();
        }
        return this.aliyunDownloadMediaInfos;
    }

    public void deleteDumpData() {
        HashSet<AliyunDownloadMediaInfo> set = new HashSet<AliyunDownloadMediaInfo>();
        ArrayList<AliyunDownloadMediaInfo> newList = new ArrayList<AliyunDownloadMediaInfo>();
        for (AliyunDownloadMediaInfo element : this.aliyunDownloadMediaInfos) {
            if (!set.add(element)) continue;
            newList.add(element);
        }
        this.aliyunDownloadMediaInfos.clear();
        this.aliyunDownloadMediaInfos.addAll(newList);
    }

    public void addDownloadMediaInfo(AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        if (this.hasAdded(aliyunDownloadMediaInfo)) {
            return;
        }
        if (this.aliyunDownloadMediaInfos != null) {
            this.aliyunDownloadMediaInfos.add(aliyunDownloadMediaInfo);
        }
    }

    public boolean hasAdded(AliyunDownloadMediaInfo info) {
        for (AliyunDownloadMediaInfo downloadMediaInfo : this.aliyunDownloadMediaInfos) {
            if (info == null || !info.getFormat().equals(downloadMediaInfo.getFormat()) || !info.getQuality().equals(downloadMediaInfo.getQuality()) || !info.getVid().equals(downloadMediaInfo.getVid()) || info.isEncripted() != downloadMediaInfo.isEncripted()) continue;
            return true;
        }
        return false;
    }

    public void deleteDownloadMediaInfo(AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        if (this.aliyunDownloadMediaInfos != null) {
            this.downloadManager.deleteFile(aliyunDownloadMediaInfo);
            this.aliyunDownloadMediaInfos.remove(aliyunDownloadMediaInfo);
        }
    }

    public void deleteAllDownloadInfo(ArrayList<AlivcDownloadMediaInfo> alivcDownloadMediaInfos) {
        if (this.aliyunDownloadMediaInfos != null) {
            this.aliyunDownloadMediaInfos.clear();
        }
        for (AlivcDownloadMediaInfo info : alivcDownloadMediaInfos) {
            this.deleteDownloadMediaInfo(info.getAliyunDownloadMediaInfo());
        }
    }
}

