/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.function;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.AliPlayer;
import com.aliyun.player.AliPlayerFactory;
import com.aliyun.player.IPlayer;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.bean.InfoBean;
import com.aliyun.player.source.UrlSource;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidMps;
import com.aliyun.player.source.VidSts;
import java.lang.ref.WeakReference;

public class AdvVideoView
extends RelativeLayout
implements View.OnClickListener {
    private static final String TAG = AdvVideoView.class.getSimpleName();
    private SurfaceView mAdvSurfaceView;
    private AliPlayer mAdvVideoAliyunVodPlayer;
    private IPlayer.OnInfoListener mOutOnInfoListener;
    private IPlayer.OnErrorListener mOutOnErrorListener;
    private IPlayer.OnCompletionListener mOutOnCompletionListener;
    private IPlayer.OnLoadingStatusListener mOutOnLoadingStatusListener;
    private IPlayer.OnRenderingStartListener mOutOnRenderingStartListener;
    private IPlayer.OnStateChangedListener mOutOnStateChangedListener;
    private IPlayer.OnPreparedListener mOutPreparedListener;
    private OnBackImageViewClickListener mOnBackImageViewClickListener;
    private int mPlayerState = -1;
    private ImageView mBackImageView;
    private TextView mAdvTipsTextView;

    public AdvVideoView(Context context) {
        super(context);
        this.init();
    }

    public AdvVideoView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AdvVideoView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.initSurfaceView();
        this.initBackImagView();
        this.initAdvTipsView();
        this.initAdvPlayer();
    }

    private void initSurfaceView() {
        this.mAdvSurfaceView = new SurfaceView(this.getContext().getApplicationContext());
        this.addSubView((View)this.mAdvSurfaceView);
    }

    private void initBackImagView() {
        this.mBackImageView = new ImageView(this.getContext());
        this.mBackImageView.setImageResource(R.drawable.ic_back);
        this.mBackImageView.setPadding(20, 20, 20, 20);
        this.mBackImageView.setVisibility(8);
        this.addSubViewByWrapContent((View)this.mBackImageView);
        this.mBackImageView.setOnClickListener((View.OnClickListener)this);
    }

    private void initAdvTipsView() {
        this.mAdvTipsTextView = new TextView(this.getContext());
        this.mAdvTipsTextView.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.alivc_fillet_bg_shape));
        int paddingLeft = (int)this.getContext().getResources().getDimension(R.dimen.alivc_common_padding_10);
        int paddingTop = (int)this.getContext().getResources().getDimension(R.dimen.alivc_common_padding_2);
        int paddingRight = (int)this.getContext().getResources().getDimension(R.dimen.alivc_common_padding_10);
        int paddingBottom = (int)this.getContext().getResources().getDimension(R.dimen.alivc_common_padding_2);
        this.mAdvTipsTextView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        this.mAdvTipsTextView.setTextSize(14.0f);
        this.mAdvTipsTextView.setTextColor(this.getResources().getColor(R.color.alivc_common_bg_white));
        this.mAdvTipsTextView.setText((CharSequence)this.getResources().getString(R.string.alivc_adv_video_tips));
        this.mAdvTipsTextView.setGravity(17);
        this.mAdvTipsTextView.setVisibility(8);
        this.addSubViewByGravityRightTop((View)this.mAdvTipsTextView);
    }

    public void onClick(View v) {
        if (v == this.mBackImageView && this.mOnBackImageViewClickListener != null) {
            this.mOnBackImageViewClickListener.onBackImageViewClick();
        }
    }

    private void addSubView(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewByWrapContent(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void addSubViewByGravityRightTop(View view) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.topMargin = (int)this.getResources().getDimension(R.dimen.alivc_common_margin_6);
        params.rightMargin = (int)this.getResources().getDimension(R.dimen.alivc_common_margin_4);
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    public SurfaceView getAdvSurfaceView() {
        return this.mAdvSurfaceView;
    }

    public void setSurfaceViewVisibility(int visibility) {
        this.mAdvSurfaceView.setVisibility(visibility);
    }

    private void initAdvPlayer() {
        SurfaceHolder holder = this.mAdvSurfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)new AdvSurfaceHolderCallback(this));
        this.mAdvVideoAliyunVodPlayer = AliPlayerFactory.createAliPlayer((Context)this.getContext().getApplicationContext());
        this.mAdvVideoAliyunVodPlayer.setAutoPlay(true);
        this.mAdvVideoAliyunVodPlayer.setOnPreparedListener((IPlayer.OnPreparedListener)new AdvPlayerOnPreparedListener(this));
        this.mAdvVideoAliyunVodPlayer.setOnLoadingStatusListener((IPlayer.OnLoadingStatusListener)new AdvPlayerOnLoadingStatusListener(this));
        this.mAdvVideoAliyunVodPlayer.setOnInfoListener((IPlayer.OnInfoListener)new AdvPlayerOnInfoListener(this));
        this.mAdvVideoAliyunVodPlayer.setOnRenderingStartListener((IPlayer.OnRenderingStartListener)new AdvPlayerOnRenderingStartLitener(this));
        this.mAdvVideoAliyunVodPlayer.setOnStateChangedListener((IPlayer.OnStateChangedListener)new AdvPlayerOnStateChangedListener(this));
        this.mAdvVideoAliyunVodPlayer.setOnCompletionListener((IPlayer.OnCompletionListener)new AdvPlayerOnCompletionListener(this));
        this.mAdvVideoAliyunVodPlayer.setOnErrorListener((IPlayer.OnErrorListener)new AdvPlayerOnErrorListener(this));
        this.mAdvVideoAliyunVodPlayer.setDisplay(this.mAdvSurfaceView.getHolder());
    }

    public void optionSetVidSts(VidSts vidSts) {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.setDataSource(vidSts);
        }
    }

    public void optionSetVidAuth(VidAuth vidAuth) {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.setDataSource(vidAuth);
        }
    }

    public void optionSetUrlSource(UrlSource urlSource) {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.setDataSource(urlSource);
        }
    }

    public void optionSetVidMps(VidMps vidMps) {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.setDataSource(vidMps);
        }
    }

    public void optionPrepare() {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.prepare();
        }
    }

    public void optionStart() {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.start();
            this.isShowAdvVideoBackIamgeView(true);
            this.isShowAdvVideoTipsTextView(true);
        }
    }

    public void optionPause() {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.pause();
        }
    }

    public void optionStop() {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.stop();
        }
    }

    public void isShowAdvVideoBackIamgeView(boolean isShow) {
        if (this.mBackImageView != null) {
            this.mBackImageView.setVisibility(isShow ? 0 : 8);
        }
    }

    public void isShowAdvVideoTipsTextView(boolean isShow) {
        if (this.mAdvTipsTextView != null) {
            this.mAdvTipsTextView.setVisibility(isShow ? 0 : 8);
        }
    }

    public AliPlayer getAdvVideoAliyunVodPlayer() {
        return this.mAdvVideoAliyunVodPlayer;
    }

    public void setOnBackImageViewClickListener(OnBackImageViewClickListener listener) {
        this.mOnBackImageViewClickListener = listener;
    }

    public void setOutPreparedListener(IPlayer.OnPreparedListener outPreparedListener) {
        this.mOutPreparedListener = outPreparedListener;
    }

    public void setOutOnLoadingStatusListener(IPlayer.OnLoadingStatusListener onLoadingStatusListener) {
        this.mOutOnLoadingStatusListener = onLoadingStatusListener;
    }

    public void setOutOnCompletionListener(IPlayer.OnCompletionListener onCompletionListener) {
        this.mOutOnCompletionListener = onCompletionListener;
    }

    public void setOutOnInfoListener(IPlayer.OnInfoListener onInfoListener) {
        this.mOutOnInfoListener = onInfoListener;
    }

    public void setOutOnRenderingStartListener(IPlayer.OnRenderingStartListener onRenderingStartListener) {
        this.mOutOnRenderingStartListener = onRenderingStartListener;
    }

    public void setOutOnErrorListener(IPlayer.OnErrorListener onErrorListener) {
        this.mOutOnErrorListener = onErrorListener;
    }

    public void setOutOnStateChangedListener(IPlayer.OnStateChangedListener listener) {
        this.mOutOnStateChangedListener = listener;
    }

    public void setAutoPlay(boolean autoPlay) {
        if (this.mAdvVideoAliyunVodPlayer != null) {
            this.mAdvVideoAliyunVodPlayer.setAutoPlay(autoPlay);
        }
    }

    public int getAdvPlayerState() {
        return this.mPlayerState;
    }

    public static class AdvPlayerOnErrorListener
    implements IPlayer.OnErrorListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnErrorListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onError(ErrorInfo errorInfo) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnErrorListener != null) {
                advVideoView.mOutOnErrorListener.onError(errorInfo);
            }
        }
    }

    public static class AdvPlayerOnCompletionListener
    implements IPlayer.OnCompletionListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnCompletionListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onCompletion() {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnCompletionListener != null) {
                advVideoView.mOutOnCompletionListener.onCompletion();
                advVideoView.isShowAdvVideoBackIamgeView(false);
                advVideoView.isShowAdvVideoTipsTextView(false);
            }
        }
    }

    public static class AdvPlayerOnStateChangedListener
    implements IPlayer.OnStateChangedListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnStateChangedListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onStateChanged(int newState) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnStateChangedListener != null) {
                advVideoView.mPlayerState = newState;
                advVideoView.mOutOnStateChangedListener.onStateChanged(newState);
            }
        }
    }

    public static class AdvPlayerOnRenderingStartLitener
    implements IPlayer.OnRenderingStartListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnRenderingStartLitener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onRenderingStart() {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnRenderingStartListener != null) {
                advVideoView.mOutOnRenderingStartListener.onRenderingStart();
                advVideoView.isShowAdvVideoBackIamgeView(true);
                advVideoView.isShowAdvVideoTipsTextView(true);
            }
        }
    }

    public static class AdvPlayerOnInfoListener
    implements IPlayer.OnInfoListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnInfoListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onInfo(InfoBean infoBean) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnInfoListener != null) {
                advVideoView.mOutOnInfoListener.onInfo(infoBean);
            }
        }
    }

    public static class AdvPlayerOnLoadingStatusListener
    implements IPlayer.OnLoadingStatusListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnLoadingStatusListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onLoadingBegin() {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnLoadingStatusListener != null) {
                advVideoView.mOutOnLoadingStatusListener.onLoadingBegin();
            }
        }

        public void onLoadingProgress(int i, float v) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnLoadingStatusListener != null) {
                advVideoView.mOutOnLoadingStatusListener.onLoadingProgress(i, v);
            }
        }

        public void onLoadingEnd() {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutOnLoadingStatusListener != null) {
                advVideoView.mOutOnLoadingStatusListener.onLoadingEnd();
            }
        }
    }

    public static class AdvPlayerOnPreparedListener
    implements IPlayer.OnPreparedListener {
        private WeakReference<AdvVideoView> weakReference;

        public AdvPlayerOnPreparedListener(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void onPrepared() {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mOutPreparedListener != null) {
                advVideoView.mOutPreparedListener.onPrepared();
            }
        }
    }

    public static class AdvSurfaceHolderCallback
    implements SurfaceHolder.Callback {
        private WeakReference<AdvVideoView> weakReference;

        public AdvSurfaceHolderCallback(AdvVideoView advVideoView) {
            this.weakReference = new WeakReference<AdvVideoView>(advVideoView);
        }

        public void surfaceCreated(SurfaceHolder holder) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mAdvVideoAliyunVodPlayer != null) {
                advVideoView.mAdvVideoAliyunVodPlayer.setDisplay(holder);
                advVideoView.mAdvVideoAliyunVodPlayer.redraw();
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mAdvVideoAliyunVodPlayer != null) {
                advVideoView.mAdvVideoAliyunVodPlayer.redraw();
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            AdvVideoView advVideoView = (AdvVideoView)((Object)this.weakReference.get());
            if (advVideoView != null && advVideoView.mAdvVideoAliyunVodPlayer != null) {
                advVideoView.mAdvVideoAliyunVodPlayer.setDisplay(null);
            }
        }
    }

    public static enum IntentPlayVideo {
        MIDDLE_END_ADV_SEEK,
        MIDDLE_ADV_SEEK,
        START_ADV,
        MIDDLE_ADV,
        END_ADV,
        REVERSE_SOURCE,
        NORMAL;

    }

    public static enum VideoState {
        VIDEO_ADV,
        VIDEO_SOURCE;

    }

    public static interface OnBackImageViewClickListener {
        public void onBackImageViewClick();
    }
}

