/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.widget.FrameLayout;
import com.aliyun.player.AliPlayer;
import com.aliyun.player.AliPlayerFactory;
import com.aliyun.player.IPlayer;
import com.aliyun.player.alivcplayerexpand.widget.IRenderView;
import com.aliyun.player.alivcplayerexpand.widget.SurfaceRenderView;
import com.aliyun.player.alivcplayerexpand.widget.TextureRenderView;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.bean.InfoBean;
import com.aliyun.player.nativeclass.CacheConfig;
import com.aliyun.player.nativeclass.MediaInfo;
import com.aliyun.player.nativeclass.PlayerConfig;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.player.source.LiveSts;
import com.aliyun.player.source.StsInfo;
import com.aliyun.player.source.UrlSource;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidMps;
import com.aliyun.player.source.VidSts;
import java.lang.ref.WeakReference;

public class AliyunRenderView
extends FrameLayout {
    private Context mContext;
    private AliPlayer mAliPlayer;
    private IRenderView mIRenderView;
    private boolean mCurrentEnableHardwareDecoder = true;
    private Surface mSurface;
    private OnVideoStreamTrackTypeListener mOnVideoStreamTrackTypeListener;
    private IPlayer.OnPreparedListener mOnPreparedListener;
    private IPlayer.OnVideoRenderedListener mOnVideoRenderedListener;
    private IPlayer.OnRenderingStartListener mOnRenderingStartListener;
    private IPlayer.OnStateChangedListener mOnStateChangedListener;
    private IPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private IPlayer.OnInfoListener mOnInfoListener;
    private IPlayer.OnTrackReadyListener mOnTrackReadyListener;
    private IPlayer.OnLoadingStatusListener mOnLoadingStatusListener;
    private IPlayer.OnSnapShotListener mOnSnapShotListener;
    private IPlayer.OnCompletionListener mOnCompletionListener;
    private IPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    private IPlayer.OnTrackChangedListener mOnTrackChangedListener;
    private IPlayer.OnErrorListener mOnErrorListener;
    private IPlayer.OnSubtitleDisplayListener mOnSubtitleDisplayListener;
    private IPlayer.OnSeiDataListener mOnSeiDataListener;
    private AliPlayer.OnVerifyTimeExpireCallback mOnVerifyTimeExpireCallback;

    public AliyunRenderView(Context context) {
        super(context);
        this.init(context);
    }

    public AliyunRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AliyunRenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.initPlayer();
    }

    private void initPlayer() {
        this.mAliPlayer = AliPlayerFactory.createAliPlayer((Context)this.mContext.getApplicationContext());
        this.initPlayerListener();
    }

    private void initPlayerListener() {
        this.mAliPlayer.setOnInfoListener((IPlayer.OnInfoListener)new OnAVPInfoListener(this));
        this.mAliPlayer.setOnTrackReadyListener((IPlayer.OnTrackReadyListener)new OnAVPTrackReadyListener(this));
        this.mAliPlayer.setOnErrorListener((IPlayer.OnErrorListener)new OnAVPErrorListener(this));
        this.mAliPlayer.setOnSeiDataListener((IPlayer.OnSeiDataListener)new OnAVPSeiDataListener(this));
        this.mAliPlayer.setOnSnapShotListener((IPlayer.OnSnapShotListener)new OnAVPSnapShotListener(this));
        this.mAliPlayer.setOnPreparedListener((IPlayer.OnPreparedListener)new OnAVPPreparedListener(this));
        this.mAliPlayer.setOnCompletionListener((IPlayer.OnCompletionListener)new OnAVPCompletionListener(this));
        this.mAliPlayer.setOnTrackChangedListener((IPlayer.OnTrackChangedListener)new OnAVPTrackChangedListener(this));
        this.mAliPlayer.setOnSeekCompleteListener((IPlayer.OnSeekCompleteListener)new OnAVPSeekCompleteListener(this));
        this.mAliPlayer.setOnVideoRenderedListener((IPlayer.OnVideoRenderedListener)new OnAVPVideoRenderedListener(this));
        this.mAliPlayer.setOnLoadingStatusListener((IPlayer.OnLoadingStatusListener)new OnAVPLoadingStatusListener(this));
        this.mAliPlayer.setOnRenderingStartListener((IPlayer.OnRenderingStartListener)new OnAVPRenderingStartListener(this));
        this.mAliPlayer.setOnVerifyTimeExpireCallback((AliPlayer.OnVerifyTimeExpireCallback)new OnAVPVerifyStsCallback(this));
        this.mAliPlayer.setOnStateChangedListener((IPlayer.OnStateChangedListener)new OnAVPStateChangedListener(this));
        this.mAliPlayer.setOnSubtitleDisplayListener((IPlayer.OnSubtitleDisplayListener)new OnAVPSubtitleDisplayListener(this));
        this.mAliPlayer.setOnVideoSizeChangedListener((IPlayer.OnVideoSizeChangedListener)new OnAVPVideoSizeChangedListener(this));
    }

    public AliPlayer getAliPlayer() {
        return this.mAliPlayer;
    }

    public void setSurfaceType(SurfaceType surfaceType) {
        this.mIRenderView = surfaceType == SurfaceType.TEXTURE_VIEW && Build.VERSION.SDK_INT >= 14 ? new TextureRenderView(this.mContext) : new SurfaceRenderView(this.mContext);
        this.initListener();
        this.addView(this.mIRenderView.getView());
    }

    public void setDataSource(VidSts vidSts) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setDataSource(vidSts);
        }
    }

    public void setDataSource(VidAuth vidAuth) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setDataSource(vidAuth);
        }
    }

    public void setDataSource(LiveSts liveSts) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setDataSource(liveSts);
        }
    }

    public void setDataSource(VidMps vidMps) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setDataSource(vidMps);
        }
    }

    public void setDataSource(UrlSource urlSource) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setDataSource(urlSource);
        }
    }

    public void updateStsInfo(StsInfo stsInfo) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.updateStsInfo(stsInfo);
        }
    }

    public void updateAuthInfo(VidAuth vidAuth) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.updateVidAuth(vidAuth);
        }
    }

    public void setMute(boolean isMute) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setMute(isMute);
        }
    }

    public void setVolume(float v) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setVolume(v);
        }
    }

    public float getVolume() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getVolume();
        }
        return 0.0f;
    }

    public void setAutoPlay(boolean isAutoPlay) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setAutoPlay(isAutoPlay);
        }
    }

    public void setSpeed(float speed) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setSpeed(speed);
        }
    }

    public void setLoop(boolean loop) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setLoop(loop);
        }
    }

    public boolean isLoop() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.isLoop();
        }
        return false;
    }

    public void snapshot() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.snapshot();
        }
    }

    public void selectTrack(int index) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.selectTrack(index);
        }
    }

    public void selectExtSubtitle(int index, boolean selected) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.selectExtSubtitle(index, selected);
        }
    }

    public void selectTrack(int index, boolean focus) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.selectTrack(index, focus);
        }
    }

    public void stop() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.stop();
        }
    }

    public void prepare() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.prepare();
        }
    }

    public void pause() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.pause();
        }
    }

    public void start() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.start();
        }
    }

    public void reload() {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.reload();
        }
    }

    public long getDuration() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getDuration();
        }
        return 0L;
    }

    public TrackInfo currentTrack(TrackInfo.Type typeVideo) {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.currentTrack(typeVideo);
        }
        return null;
    }

    @Deprecated
    public TrackInfo currentTrack(int ordinal) {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.currentTrack(ordinal);
        }
        return null;
    }

    public void seekTo(long position, IPlayer.SeekMode seekMode) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.seekTo(position, seekMode);
        }
    }

    private void initListener() {
        this.mIRenderView.addRenderCallback(new MyRenderViewCallback(this));
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setCacheConfig(cacheConfig);
        }
    }

    public void setPlayerConfig(PlayerConfig playerConfig) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setConfig(playerConfig);
        }
    }

    public PlayerConfig getPlayerConfig() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getConfig();
        }
        return null;
    }

    public void setScaleModel(IPlayer.ScaleMode scaleMode) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setScaleMode(scaleMode);
        }
    }

    public IPlayer.ScaleMode getScaleModel() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getScaleMode();
        }
        return IPlayer.ScaleMode.SCALE_ASPECT_FIT;
    }

    public void setRotateModel(IPlayer.RotateMode rotateModel) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setRotateMode(rotateModel);
        }
    }

    public IPlayer.RotateMode getRotateModel() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getRotateMode();
        }
        return IPlayer.RotateMode.ROTATE_0;
    }

    public void setMirrorMode(IPlayer.MirrorMode mirrorMode) {
        if (this.mAliPlayer != null) {
            this.mAliPlayer.setMirrorMode(mirrorMode);
        }
    }

    public IPlayer.MirrorMode getMirrorMode() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getMirrorMode();
        }
        return IPlayer.MirrorMode.MIRROR_MODE_NONE;
    }

    public MediaInfo getMediaInfo() {
        if (this.mAliPlayer != null) {
            return this.mAliPlayer.getMediaInfo();
        }
        return null;
    }

    public void enableHardwareDecoder(boolean enableHardwareDecoder) {
        if (this.mAliPlayer != null) {
            this.mCurrentEnableHardwareDecoder = enableHardwareDecoder;
            this.mAliPlayer.enableHardwareDecoder(enableHardwareDecoder);
        }
    }

    public void setDefaultBandWidth(int bandWidth) {
        if (this.mAliPlayer != null) {
            Log.e((String)"abc : ", (String)("setDefaultBandWidth: " + bandWidth));
            this.mAliPlayer.setDefaultBandWidth(bandWidth);
        }
    }

    public boolean isHardwareDecoder() {
        return this.mCurrentEnableHardwareDecoder;
    }

    public void release() {
        if (this.mAliPlayer != null) {
            this.stop();
            this.mAliPlayer.setSurface(null);
            this.mAliPlayer.release();
            this.mAliPlayer = null;
        }
        this.mSurface = null;
    }

    public void setOnVideoStreamTrackType(OnVideoStreamTrackTypeListener listener) {
        this.mOnVideoStreamTrackTypeListener = listener;
    }

    public void setOnPreparedListener(IPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    private void onPrepared() {
        if (this.mOnPreparedListener != null) {
            this.mOnPreparedListener.onPrepared();
        }
        if (this.mOnVideoStreamTrackTypeListener != null) {
            TrackInfo trackVideo = this.mAliPlayer.currentTrack(TrackInfo.Type.TYPE_VIDEO);
            TrackInfo trackAudio = this.mAliPlayer.currentTrack(TrackInfo.Type.TYPE_AUDIO);
            if (trackVideo == null && trackAudio != null) {
                this.mOnVideoStreamTrackTypeListener.onAudioOnlyType();
            } else if (trackVideo != null && trackAudio == null) {
                this.mOnVideoStreamTrackTypeListener.onVideoOnlyType();
            }
        }
    }

    public void setOnVideoRenderedListener(IPlayer.OnVideoRenderedListener listener) {
        this.mOnVideoRenderedListener = listener;
    }

    private void onVideoRendered(long timeMs, long pts) {
        if (this.mOnVideoRenderedListener != null) {
            this.mOnVideoRenderedListener.onVideoRendered(timeMs, pts);
        }
    }

    public void setOnRenderingStartListener(IPlayer.OnRenderingStartListener listener) {
        this.mOnRenderingStartListener = listener;
    }

    private void onRenderingStart() {
        if (this.mOnRenderingStartListener != null) {
            this.mOnRenderingStartListener.onRenderingStart();
        }
    }

    public void setOnStateChangedListener(IPlayer.OnStateChangedListener listener) {
        this.mOnStateChangedListener = listener;
    }

    private void onStateChangedListener(int newState) {
        if (this.mOnStateChangedListener != null) {
            this.mOnStateChangedListener.onStateChanged(newState);
        }
    }

    public void setOnVideoSizeChangedListener(IPlayer.OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    private void onVideoSizeChanged(int width, int height) {
        if (this.mOnVideoSizeChangedListener != null) {
            this.mOnVideoSizeChangedListener.onVideoSizeChanged(width, height);
        }
    }

    public void setOnInfoListener(IPlayer.OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    private void onInfo(InfoBean infoBean) {
        if (this.mOnInfoListener != null) {
            this.mOnInfoListener.onInfo(infoBean);
        }
    }

    public void setOnTrackReadyListenenr(IPlayer.OnTrackReadyListener listener) {
        this.mOnTrackReadyListener = listener;
    }

    private void onTrackReady(MediaInfo mediaInfo) {
        if (this.mOnTrackReadyListener != null) {
            this.mOnTrackReadyListener.onTrackReady(mediaInfo);
        }
    }

    public void setOnLoadingStatusListener(IPlayer.OnLoadingStatusListener listener) {
        this.mOnLoadingStatusListener = listener;
    }

    private void onLoadingBegin() {
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingBegin();
        }
    }

    private void onLoadingProgress(int percent, float netSpeed) {
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingProgress(percent, netSpeed);
        }
    }

    private void onLoadingEnd() {
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingEnd();
        }
    }

    public void setOnSnapShotListener(IPlayer.OnSnapShotListener listener) {
        this.mOnSnapShotListener = listener;
    }

    private void onSnapShot(Bitmap bitmap, int with, int height) {
        if (this.mOnSnapShotListener != null) {
            this.mOnSnapShotListener.onSnapShot(bitmap, with, height);
        }
    }

    public void setOnCompletionListener(IPlayer.OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    private void onCompletion() {
        if (this.mOnCompletionListener != null) {
            this.mOnCompletionListener.onCompletion();
        }
    }

    public void setOnSeekCompleteListener(IPlayer.OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    private void onSeekComplete() {
        if (this.mOnSeekCompleteListener != null) {
            this.mOnSeekCompleteListener.onSeekComplete();
        }
    }

    public void setOnTrackChangedListener(IPlayer.OnTrackChangedListener listener) {
        this.mOnTrackChangedListener = listener;
    }

    private void onChangedSuccess(TrackInfo trackInfo) {
        if (this.mOnTrackChangedListener != null) {
            this.mOnTrackChangedListener.onChangedSuccess(trackInfo);
        }
    }

    private void onChangedFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
        if (this.mOnTrackChangedListener != null) {
            this.mOnTrackChangedListener.onChangedFail(trackInfo, errorInfo);
        }
    }

    public void setOnErrorListener(IPlayer.OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    private void onError(ErrorInfo errorInfo) {
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onError(errorInfo);
        }
    }

    private void oSubtitleHeader(int index, String data) {
        if (this.mOnSubtitleDisplayListener != null) {
            this.mOnSubtitleDisplayListener.onSubtitleHeader(index, data);
        }
    }

    private void onSubtitleHide(int trackIndex, long id2) {
        if (this.mOnSubtitleDisplayListener != null) {
            this.mOnSubtitleDisplayListener.onSubtitleHide(trackIndex, id2);
        }
    }

    private void onSubtitleShow(int trackIndex, long id2, String data) {
        if (this.mOnSubtitleDisplayListener != null) {
            this.mOnSubtitleDisplayListener.onSubtitleShow(trackIndex, id2, data);
        }
    }

    private void onSubtitleExtAdded(int trackIndex, String url) {
        if (this.mOnSubtitleDisplayListener != null) {
            this.mOnSubtitleDisplayListener.onSubtitleExtAdded(trackIndex, url);
        }
    }

    public void setOnSubtitleDisplayListener(IPlayer.OnSubtitleDisplayListener listener) {
        this.mOnSubtitleDisplayListener = listener;
    }

    private void onSeiData(int type, byte[] bytes) {
        if (this.mOnSeiDataListener != null) {
            this.mOnSeiDataListener.onSeiData(type, bytes);
        }
    }

    public void setOnSeiDataListener(IPlayer.OnSeiDataListener listener) {
        this.mOnSeiDataListener = listener;
    }

    public void setOnVerifyTimeExpireCallback(AliPlayer.OnVerifyTimeExpireCallback listener) {
        this.mOnVerifyTimeExpireCallback = listener;
    }

    private AliPlayer.Status onVerifyAuth(VidAuth vidAuth) {
        if (this.mOnVerifyTimeExpireCallback != null) {
            return this.mOnVerifyTimeExpireCallback.onVerifyAuth(vidAuth);
        }
        return AliPlayer.Status.Valid;
    }

    private AliPlayer.Status onVerifySts(StsInfo stsInfo) {
        if (this.mOnVerifyTimeExpireCallback != null) {
            return this.mOnVerifyTimeExpireCallback.onVerifySts(stsInfo);
        }
        return AliPlayer.Status.Valid;
    }

    private static class OnAVPVerifyStsCallback
    implements AliPlayer.OnVerifyTimeExpireCallback {
        private WeakReference<AliyunRenderView> weakReference;

        public OnAVPVerifyStsCallback(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public AliPlayer.Status onVerifySts(StsInfo stsInfo) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                return aliyunRenderView.onVerifySts(stsInfo);
            }
            return AliPlayer.Status.Valid;
        }

        public AliPlayer.Status onVerifyAuth(VidAuth vidAuth) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                return aliyunRenderView.onVerifyAuth(vidAuth);
            }
            return AliPlayer.Status.Valid;
        }
    }

    private static class OnAVPSeiDataListener
    implements IPlayer.OnSeiDataListener {
        private WeakReference<AliyunRenderView> weakReference;

        public OnAVPSeiDataListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onSeiData(int type, byte[] bytes) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSeiData(type, bytes);
            }
        }
    }

    private static class OnAVPSubtitleDisplayListener
    implements IPlayer.OnSubtitleDisplayListener {
        private WeakReference<AliyunRenderView> weakReference;

        public OnAVPSubtitleDisplayListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onSubtitleExtAdded(int trackIndex, String url) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSubtitleExtAdded(trackIndex, url);
            }
        }

        public void onSubtitleShow(int trackIndex, long id2, String data) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSubtitleShow(trackIndex, id2, data);
            }
        }

        public void onSubtitleHide(int trackIndex, long id2) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSubtitleHide(trackIndex, id2);
            }
        }

        public void onSubtitleHeader(int index, String data) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.oSubtitleHeader(index, data);
            }
        }
    }

    private static class OnAVPErrorListener
    implements IPlayer.OnErrorListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPErrorListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onError(ErrorInfo errorInfo) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onError(errorInfo);
            }
        }
    }

    private static class OnAVPTrackChangedListener
    implements IPlayer.OnTrackChangedListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPTrackChangedListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onChangedSuccess(TrackInfo trackInfo) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onChangedSuccess(trackInfo);
            }
        }

        public void onChangedFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onChangedFail(trackInfo, errorInfo);
            }
        }
    }

    private static class OnAVPSeekCompleteListener
    implements IPlayer.OnSeekCompleteListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPSeekCompleteListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onSeekComplete() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSeekComplete();
            }
        }
    }

    private static class OnAVPCompletionListener
    implements IPlayer.OnCompletionListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPCompletionListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onCompletion() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onCompletion();
            }
        }
    }

    private static class OnAVPSnapShotListener
    implements IPlayer.OnSnapShotListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPSnapShotListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onSnapShot(Bitmap bitmap, int with, int height) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onSnapShot(bitmap, with, height);
            }
        }
    }

    private static class OnAVPLoadingStatusListener
    implements IPlayer.OnLoadingStatusListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPLoadingStatusListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onLoadingBegin() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onLoadingBegin();
            }
        }

        public void onLoadingProgress(int percent, float netSpeed) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onLoadingProgress(percent, netSpeed);
            }
        }

        public void onLoadingEnd() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onLoadingEnd();
            }
        }
    }

    private static class OnAVPTrackReadyListener
    implements IPlayer.OnTrackReadyListener {
        private WeakReference<AliyunRenderView> mRenderViewWeakReference;

        public OnAVPTrackReadyListener(AliyunRenderView renderView) {
            this.mRenderViewWeakReference = new WeakReference<AliyunRenderView>(renderView);
        }

        public void onTrackReady(MediaInfo mediaInfo) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.mRenderViewWeakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onTrackReady(mediaInfo);
            }
        }
    }

    private static class OnAVPInfoListener
    implements IPlayer.OnInfoListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPInfoListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onInfo(InfoBean infoBean) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onInfo(infoBean);
            }
        }
    }

    private static class OnAVPVideoSizeChangedListener
    implements IPlayer.OnVideoSizeChangedListener {
        private WeakReference<AliyunRenderView> weakReference;

        public OnAVPVideoSizeChangedListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onVideoSizeChanged(int width, int height) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onVideoSizeChanged(width, height);
            }
        }
    }

    private static class OnAVPStateChangedListener
    implements IPlayer.OnStateChangedListener {
        private WeakReference<AliyunRenderView> weakReference;

        public OnAVPStateChangedListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onStateChanged(int i) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onStateChangedListener(i);
            }
        }
    }

    private static class OnAVPRenderingStartListener
    implements IPlayer.OnRenderingStartListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPRenderingStartListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onRenderingStart() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onRenderingStart();
            }
        }
    }

    private static class OnAVPVideoRenderedListener
    implements IPlayer.OnVideoRenderedListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPVideoRenderedListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onVideoRendered(long timeMs, long pts) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onVideoRendered(timeMs, pts);
            }
        }
    }

    public static interface OnVideoStreamTrackTypeListener {
        public void onVideoOnlyType();

        public void onAudioOnlyType();
    }

    private static class OnAVPPreparedListener
    implements IPlayer.OnPreparedListener {
        private WeakReference<AliyunRenderView> weakReference;

        private OnAVPPreparedListener(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        public void onPrepared() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null) {
                aliyunRenderView.onPrepared();
            }
        }
    }

    private static class MyRenderViewCallback
    implements IRenderView.IRenderCallback {
        private WeakReference<AliyunRenderView> weakReference;

        private MyRenderViewCallback(AliyunRenderView aliyunRenderView) {
            this.weakReference = new WeakReference<AliyunRenderView>(aliyunRenderView);
        }

        @Override
        public void onSurfaceCreate(Surface surface) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null && aliyunRenderView.mAliPlayer != null) {
                aliyunRenderView.mSurface = surface;
                aliyunRenderView.mAliPlayer.setSurface(surface);
            }
        }

        @Override
        public void onSurfaceChanged(int width, int height) {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null && aliyunRenderView.mAliPlayer != null) {
                aliyunRenderView.mAliPlayer.surfaceChanged();
            }
        }

        @Override
        public void onSurfaceDestroyed() {
            AliyunRenderView aliyunRenderView = (AliyunRenderView)((Object)this.weakReference.get());
            if (aliyunRenderView != null && aliyunRenderView.mAliPlayer != null) {
                aliyunRenderView.mAliPlayer.setSurface(null);
            }
        }
    }

    public static enum SurfaceType {
        TEXTURE_VIEW,
        SURFACE_VIEW;

    }
}

